/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.API})
public class MetaDataEntry {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private String key;
    private Object value;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.logger.finest("setting meta-data key: " + key);
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public <T> T getValue(Class<T> targetClass) {
        return (T)this.getValue();
    }

    public void setValue(Object value) {
        this.logger.finest("setting meta-data value: " + value);
        this.value = value;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public <T> T getProperty(String key, Class<T> targetClass) {
        return (T)this.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.logger.finest("new property added key: " + key + " value: " + value + " for metadata-key: " + this.key);
        this.properties.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaDataEntry)) {
            return false;
        }
        MetaDataEntry that = (MetaDataEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.createNullAwareHashCode(this.value) : 0);
        result = 31 * result + (this.properties != null ? this.createNullAwareHashCode(this.properties) : 0);
        return result;
    }

    private int createNullAwareHashCode(Object o) {
        try {
            return o.hashCode();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }
}

