/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.recorder;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.recorder.ProcessedInformationRecorder;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorageEntry;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.CrossValidationUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class CrossValidationUserInputRecorder
implements ProcessedInformationRecorder {
    private ELHelper elHelper;

    public void recordUserInput(UIComponent uiComponent, Object value) {
        if (!(uiComponent instanceof EditableValueHolder)) {
            return;
        }
        ProcessedInformationStorage processedInformationStorage = CrossValidationUtils.getOrInitProcessedInformationStorage();
        PropertyDetails propertyDetails = this.getELHelper().getPropertyDetailsOfValueBinding(uiComponent);
        if (propertyDetails == null) {
            return;
        }
        ProcessedInformationStorageEntry entry = new ProcessedInformationStorageEntry();
        entry.setBean(propertyDetails.getBaseObject());
        entry.setConvertedValue(value);
        entry.setComponent(uiComponent);
        entry.setClientId(uiComponent.getClientId(FacesContext.getCurrentInstance()));
        String key = propertyDetails.getKey();
        if (processedInformationStorage.containsEntry(key) && processedInformationStorage.getEntry(key).getBean() != null && !processedInformationStorage.getEntry(key).getBean().equals(entry.getBean())) {
            List<ProcessedInformationStorageEntry> furtherEntries = processedInformationStorage.getEntry(key).getFurtherEntries();
            if (furtherEntries == null) {
                furtherEntries = new ArrayList<ProcessedInformationStorageEntry>();
                processedInformationStorage.getEntry(key).setFurtherEntries(furtherEntries);
            }
            furtherEntries.add(entry);
        } else {
            processedInformationStorage.setEntry(key, entry);
        }
    }

    protected ELHelper getELHelper() {
        if (this.elHelper == null) {
            this.elHelper = ExtValUtils.getELHelper();
        }
        return this.elHelper;
    }
}

