/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.jsf;

import java.util.Iterator;
import java.util.Set;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.AccessScopeManager;
import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.ConversationAccessLifetimeAspect;
import org.apache.myfaces.orchestra.conversation.ConversationManager;

public class AccessScopePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private final Log log = LogFactory.getLog(AccessScopePhaseListener.class);
    private static final String OLD_VIEW_KEY = AccessScopePhaseListener.class.getName() + ":oldView";

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        PhaseId pid = event.getPhaseId();
        if (pid == PhaseId.RENDER_RESPONSE) {
            this.doBeforeRenderResponse(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        PhaseId pid = event.getPhaseId();
        if (pid == PhaseId.RESTORE_VIEW) {
            this.doAfterRestoreView(event);
        } else if (pid == PhaseId.RENDER_RESPONSE) {
            this.doAfterRenderResponse(event);
        }
    }

    private void doAfterRestoreView(PhaseEvent event) {
        FacesContext fc = event.getFacesContext();
        UIViewRoot oldViewRoot = fc.getViewRoot();
        if (oldViewRoot != null && fc.getRenderResponse()) {
            oldViewRoot = null;
        }
        fc.getExternalContext().getRequestMap().put(OLD_VIEW_KEY, oldViewRoot);
    }

    private void doBeforeRenderResponse(PhaseEvent event) {
        AccessScopeManager accessManager = AccessScopeManager.getInstance();
        accessManager.beginRecording();
    }

    private void doAfterRenderResponse(PhaseEvent event) {
        UIViewRoot oldViewRoot;
        FacesContext fc = event.getFacesContext();
        UIViewRoot viewRoot = fc.getViewRoot();
        if (viewRoot != (oldViewRoot = (UIViewRoot)fc.getExternalContext().getRequestMap().get(OLD_VIEW_KEY))) {
            this.invalidateAccessScopedConversations(event.getFacesContext().getViewRoot().getViewId());
        }
    }

    protected void invalidateAccessScopedConversations(String viewId) {
        Set ignoredViewIds;
        AccessScopeManager accessManager = AccessScopeManager.getInstance();
        if (accessManager.isIgnoreRequest()) {
            return;
        }
        if (accessManager.getAccessScopeManagerConfiguration() != null && (ignoredViewIds = accessManager.getAccessScopeManagerConfiguration().getIgnoreViewIds()) != null && ignoredViewIds.contains(viewId)) {
            return;
        }
        ConversationManager conversationManager = ConversationManager.getInstance(false);
        if (conversationManager == null) {
            return;
        }
        boolean isDebug = this.log.isDebugEnabled();
        Iterator iterConversations = conversationManager.iterateConversations();
        while (iterConversations.hasNext()) {
            Conversation conversation = (Conversation)iterConversations.next();
            ConversationAccessLifetimeAspect aspect = (ConversationAccessLifetimeAspect)conversation.getAspect(ConversationAccessLifetimeAspect.class);
            if (aspect == null) continue;
            if (aspect.isAccessed()) {
                if (!isDebug) continue;
                this.log.debug((Object)("Not clearing accessed conversation " + conversation.getName() + " after rendering view " + viewId));
                continue;
            }
            if (isDebug) {
                this.log.debug((Object)("Clearing access-scoped conversation " + conversation.getName() + " after rendering view " + viewId));
            }
            conversation.invalidate();
        }
    }
}

