/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessKeyMap {
    private static final Logger LOG = LoggerFactory.getLogger(AccessKeyMap.class);
    private static final char[] KEYS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final String REQUEST_MAP_KEY = "accessKeysRequestMapKey";
    private HashSet set;
    private StringBuilder duplicated = new StringBuilder();

    public static AccessKeyMap getInstance(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        AccessKeyMap keyMap = (AccessKeyMap)requestMap.get(REQUEST_MAP_KEY);
        if (keyMap == null) {
            keyMap = new AccessKeyMap();
            requestMap.put(REQUEST_MAP_KEY, keyMap);
        }
        return keyMap;
    }

    private AccessKeyMap() {
        this.set = new HashSet();
    }

    private HashSet getSet() {
        return this.set;
    }

    private String getDuplicated() {
        return this.duplicated.toString();
    }

    private void addDublicated(char key) {
        this.duplicated = this.duplicated.append(key);
    }

    public static boolean addAccessKey(FacesContext facesContext, Character keyParameter) {
        Character key = keyParameter;
        key = Character.valueOf(key.toString().toLowerCase(Locale.ENGLISH).charAt(0));
        AccessKeyMap instance = AccessKeyMap.getInstance(facesContext);
        if (instance.getSet().contains(key)) {
            instance.addDublicated(key.charValue());
            return false;
        }
        instance.getSet().add(key);
        return true;
    }

    public static String getDublicatedKeys(FacesContext facesContext) {
        return AccessKeyMap.getInstance(facesContext).getDuplicated();
    }

    public static String getUnusedKeys(FacesContext facesContext) {
        HashSet set = AccessKeyMap.getInstance(facesContext).getSet();
        StringBuilder sb = new StringBuilder();
        for (char key : KEYS) {
            if (set.contains(Character.valueOf(key))) continue;
            sb.append(key);
        }
        return sb.toString();
    }
}

