/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.event.MethodExpressionTreeExpansionListener;
import org.apache.myfaces.tobago.event.MethodExpressionTreeMarkedListener;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.apache.myfaces.tobago.layout.Measure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeNodeTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(TreeNodeTag.class);
    private ValueExpression marked;
    private MethodExpression treeExpansionListener;
    private ValueExpression markup;
    private MethodExpression treeMarkedListener;
    private ValueExpression expanded;
    private ValueExpression width;
    private ValueExpression tip;
    private ValueExpression disabled;
    private ValueExpression selected;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.TreeNode";
    }

    public String getRendererType() {
        return "TreeNode";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UITreeNode component = (UITreeNode)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.marked != null) {
            if (!this.marked.isLiteralText()) {
                component.setValueExpression("marked", this.marked);
            } else {
                component.setMarked(Boolean.parseBoolean(this.marked.getExpressionString()));
            }
        }
        if (this.treeExpansionListener != null) {
            component.addTreeExpansionListener(new MethodExpressionTreeExpansionListener(this.treeExpansionListener));
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.treeMarkedListener != null) {
            component.addTreeMarkedListener(new MethodExpressionTreeMarkedListener(this.treeMarkedListener));
        }
        if (this.expanded != null) {
            if (!this.expanded.isLiteralText()) {
                component.setValueExpression("expanded", this.expanded);
            } else {
                component.setExpanded(Boolean.parseBoolean(this.expanded.getExpressionString()));
            }
        }
        if (this.width != null) {
            if (!this.width.isLiteralText()) {
                component.setValueExpression("width", this.width);
            } else {
                component.setWidth(Measure.valueOf(this.width.getExpressionString()));
            }
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
        if (this.disabled != null) {
            if (!this.disabled.isLiteralText()) {
                component.setValueExpression("disabled", this.disabled);
            } else {
                component.setDisabled(Boolean.parseBoolean(this.disabled.getExpressionString()));
            }
        }
        if (this.selected != null) {
            if (!this.selected.isLiteralText()) {
                component.setValueExpression("selected", this.selected);
            } else {
                component.setSelected(Boolean.parseBoolean(this.selected.getExpressionString()));
            }
        }
    }

    public ValueExpression getMarked() {
        return this.marked;
    }

    public void setMarked(ValueExpression marked) {
        this.marked = marked;
    }

    public MethodExpression getTreeExpansionListener() {
        return this.treeExpansionListener;
    }

    public void setTreeExpansionListener(MethodExpression treeExpansionListener) {
        this.treeExpansionListener = treeExpansionListener;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public MethodExpression getTreeMarkedListener() {
        return this.treeMarkedListener;
    }

    public void setTreeMarkedListener(MethodExpression treeMarkedListener) {
        this.treeMarkedListener = treeMarkedListener;
    }

    public ValueExpression getExpanded() {
        return this.expanded;
    }

    public void setExpanded(ValueExpression expanded) {
        this.expanded = expanded;
    }

    public ValueExpression getWidth() {
        return this.width;
    }

    public void setWidth(ValueExpression width) {
        this.width = width;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public ValueExpression getDisabled() {
        return this.disabled;
    }

    public void setDisabled(ValueExpression disabled) {
        this.disabled = disabled;
    }

    public ValueExpression getSelected() {
        return this.selected;
    }

    public void setSelected(ValueExpression selected) {
        this.selected = selected;
    }

    public void release() {
        super.release();
        this.marked = null;
        this.treeExpansionListener = null;
        this.markup = null;
        this.treeMarkedListener = null;
        this.expanded = null;
        this.width = null;
        this.tip = null;
        this.disabled = null;
        this.selected = null;
    }
}

