/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib.component;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeSource2;
import org.apache.myfaces.tobago.event.ValueExpressionTabChangeListener;

public abstract class TabChangeListenerTag
extends TagSupport {
    private static final long serialVersionUID = 2L;
    private ValueExpression type;
    private ValueExpression binding;

    public void setType(ValueExpression type) {
        this.type = type;
    }

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }

    public int doStartTag() throws JspException {
        Object value;
        UIComponentClassicTagBase tag = UIComponentELTag.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in faces tag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Component Instance is null");
        }
        if (!(component instanceof TabChangeSource2)) {
            throw new JspException("Component " + component.getClass().getName() + " is not instanceof TabChangeSource2");
        }
        TabChangeSource2 changeSource = (TabChangeSource2)component;
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        TabChangeListener handler = null;
        if (this.binding != null && !this.binding.isLiteralText() && (value = this.binding.getValue(elContext)) instanceof TabChangeListener) {
            handler = (TabChangeListener)value;
        }
        if (handler == null && this.type != null && (handler = this.createTabChangeListener((String)this.type.getValue(elContext))) != null && this.binding != null) {
            this.binding.setValue(elContext, (Object)handler);
        }
        if (handler != null) {
            if (this.binding != null) {
                changeSource.addTabChangeListener(new ValueExpressionTabChangeListener((String)this.type.getValue(elContext), this.binding));
            } else {
                changeSource.addTabChangeListener(handler);
            }
        }
        return 0;
    }

    protected TabChangeListener createTabChangeListener(String className) throws JspException {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            return (TabChangeListener)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

