// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeListbox;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.TreeListboxTagDeclaration}.
 */
public final class TreeListboxTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(TreeListboxTag.class);
  private javax.el.ValueExpression  selectable;
  private javax.el.ValueExpression  required;
  private javax.el.ValueExpression  state;
  private javax.el.ValueExpression  value;
  private javax.el.ValueExpression  markup;
  private String var;

  @Override
  public String getComponentType() {
    return UITreeListbox.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "TreeListbox";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UITreeListbox component = (UITreeListbox) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (selectable != null) {
      component.setValueExpression("selectable", selectable);
    }

    if (required != null) {
      if (!required.isLiteralText()) {
        component.setValueExpression("required", required);
      } else {
        component.setRequired(Boolean.parseBoolean(required.getExpressionString()));
      }
    }
    if (state != null) {
      if (!state.isLiteralText()) {
        component.setValueExpression("state", state);
      /*} else {
        component.setState(state.getExpressionString());*/
      }
    }
    if (value != null) {
      component.setValueExpression("value", value);
    }

    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (var != null) {
      component.setVar(var);
    }

  }

  public javax.el.ValueExpression getSelectable() {
    return selectable;
  }

  public void setSelectable(final javax.el.ValueExpression selectable) {
    this.selectable = selectable;
  }

  public javax.el.ValueExpression getRequired() {
    return required;
  }

  public void setRequired(final javax.el.ValueExpression required) {
    this.required = required;
  }

  public javax.el.ValueExpression getState() {
    return state;
  }

  public void setState(final javax.el.ValueExpression state) {
    this.state = state;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public String getVar() {
    return var;
  }

  public void setVar(final String var) {
    this.var = var;
  }



  @Override
  public void release() {
    super.release();
    selectable = null;
    required = null;
    state = null;
    value = null;
    markup = null;
    var = null;
  }
}