/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.myfaces.tobago.internal.util.ResponseWriterBuffer;
import org.apache.myfaces.tobago.internal.util.WriterHelper;

public final class HtmlWriterHelper
extends WriterHelper {
    private static final char[][] CHARS_TO_ESCAPE;

    @Deprecated(since="4.3.0", forRemoval=true)
    public HtmlWriterHelper(Writer out, String characterEncoding) {
        this(out, Charset.forName(characterEncoding));
    }

    public HtmlWriterHelper(Writer out, Charset charset) {
        super(out, charset);
    }

    @Override
    protected void writeEncodedValue(char[] text, int start, int length, boolean isAttribute) throws IOException {
        int localIndex = -1;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch < CHARS_TO_ESCAPE.length && CHARS_TO_ESCAPE[ch] == null) continue;
            localIndex = i;
            break;
        }
        Writer out = this.getOut();
        if (localIndex == -1) {
            out.write(text, start, length);
        } else {
            out.write(text, start, localIndex);
            ResponseWriterBuffer buffer = this.getBuffer();
            for (int i = localIndex; i < end; ++i) {
                char ch = text[i];
                if (ch < CHARS_TO_ESCAPE.length) {
                    if (isAttribute && ch == '&' && i + 1 < end && text[i + 1] == '{') {
                        buffer.addToBuffer('&');
                        continue;
                    }
                    if (CHARS_TO_ESCAPE[ch] != null) {
                        buffer.addToBuffer(CHARS_TO_ESCAPE[ch]);
                        continue;
                    }
                    buffer.addToBuffer(ch);
                    continue;
                }
                if (this.isUtf8()) {
                    buffer.addToBuffer(ch);
                    continue;
                }
                if (ch <= '\u00ff') {
                    buffer.flushBuffer();
                    out.write(38);
                    char[] chars = ISO8859_1_ENTITIES[ch - 160];
                    out.write(chars, 0, chars.length);
                    out.write(59);
                    continue;
                }
                buffer.flushBuffer();
                this.writeDecRef(ch);
            }
            buffer.flushBuffer();
        }
    }

    static {
        int i;
        CHARS_TO_ESCAPE = new char[160][];
        for (i = 0; i < 32; ++i) {
            HtmlWriterHelper.CHARS_TO_ESCAPE[i] = EMPTY;
        }
        for (i = 127; i < 160; ++i) {
            HtmlWriterHelper.CHARS_TO_ESCAPE[i] = EMPTY;
        }
        HtmlWriterHelper.CHARS_TO_ESCAPE[9] = "&#x09;".toCharArray();
        HtmlWriterHelper.CHARS_TO_ESCAPE[10] = "&#x0a;".toCharArray();
        HtmlWriterHelper.CHARS_TO_ESCAPE[13] = "&#x0d;".toCharArray();
        HtmlWriterHelper.CHARS_TO_ESCAPE[39] = "&#x27;".toCharArray();
        HtmlWriterHelper.CHARS_TO_ESCAPE[38] = "&amp;".toCharArray();
        HtmlWriterHelper.CHARS_TO_ESCAPE[60] = "&lt;".toCharArray();
        HtmlWriterHelper.CHARS_TO_ESCAPE[62] = "&gt;".toCharArray();
    }
}

