/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.HtmlBufferResponseWriterWrapper;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;

public class ExtensionsPhaseListener
implements PhaseListener {
    private static final Log log = LogFactory.getLog((Class)ExtensionsPhaseListener.class);
    public static final String ORG_APACHE_MYFACES_MY_FACES_JAVASCRIPT = "org.apache.myfaces.myFacesJavascript";
    public static final String LISTENERS_MAP = "_MyFaces_inputAjax_listenersMap";

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void beforePhase(PhaseEvent event) {
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        try {
            this.getJavaScriptCodeAndStoreInRequest(facesContext);
        }
        catch (IOException e) {
            log.error((Object)"Exception while rendering extension filter code.", (Throwable)e);
        }
    }

    private void getJavaScriptCodeAndStoreInRequest(FacesContext facesContext) throws IOException {
        Object myFacesJavascript = facesContext.getExternalContext().getRequestMap().get(ORG_APACHE_MYFACES_MY_FACES_JAVASCRIPT);
        if (myFacesJavascript != null) {
            return;
        }
        facesContext.getExternalContext().getRequestMap().put(ORG_APACHE_MYFACES_MY_FACES_JAVASCRIPT, ExtensionsPhaseListener.getCodeBeforeBodyEnd(facesContext));
    }

    private static String getCodeBeforeBodyEnd(FacesContext facesContext) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        HtmlBufferResponseWriterWrapper writerWrapper = HtmlBufferResponseWriterWrapper.getInstance(responseWriter);
        facesContext.setResponseWriter((ResponseWriter)writerWrapper);
        ExtensionsPhaseListener.writeCodeBeforeBodyEnd(facesContext);
        if (responseWriter != null) {
            facesContext.setResponseWriter(responseWriter);
        }
        return writerWrapper.toString();
    }

    public static void writeCodeBeforeBodyEnd(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext());
        if (myfacesConfig.isDetectJavascript() && !JavascriptUtils.isJavascriptDetected(facesContext.getExternalContext())) {
            writer.startElement("script", null);
            writer.writeAttribute("attr", (Object)"text/javascript", null);
            StringBuffer script = new StringBuffer();
            script.append("document.location.replace('").append(facesContext.getApplication().getViewHandler().getResourceURL(facesContext, "/_javascriptDetector_")).append("?goto=").append(facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId())).append("');");
            writer.writeText((Object)script.toString(), null);
            writer.endElement("script");
        }
        if (myfacesConfig.isAutoScroll()) {
            HtmlRendererUtils.renderAutoScrollFunction(facesContext, writer);
        }
        try {
            List listeners = (List)facesContext.getExternalContext().getRequestMap().get("org.apache.myfaces.Listener");
            if (listeners != null && listeners.size() > 0) {
                writer.startElement("script", null);
                writer.writeAttribute("attr", (Object)"text/javascript", null);
                StringBuffer buff = new StringBuffer();
                String mapName = LISTENERS_MAP;
                buff.append("var ").append(mapName).append(" = new Object();\n");
                for (int i = 0; i < listeners.size(); ++i) {
                    Map listenerItem = (Map)listeners.get(i);
                    String listenerId = (String)listenerItem.get("listenerId");
                    String listenOn = (String)listenerItem.get("listenOn");
                    String action = (String)listenerItem.get("action");
                    String eventType = (String)listenerItem.get("eventType");
                    buff.append("var _MyFaces_listenerItem = ").append(mapName).append("['").append(listenOn).append("'];\n");
                    buff.append("if(!_MyFaces_listenerItem) {\n");
                    buff.append("    _MyFaces_listenerItem = new Array();\n");
                    buff.append("    ").append(mapName).append("['").append(listenOn).append("'] = _MyFaces_listenerItem;\n");
                    buff.append("}\n");
                    buff.append("var _MyFaces_listener = new Object();\n");
                    buff.append("_MyFaces_listener['id'] = '").append(listenerId).append("';\n");
                    buff.append("_MyFaces_listener['action'] = '").append(action).append("';\n");
                    buff.append("_MyFaces_listener['eventType'] = '").append(eventType).append("';\n");
                    buff.append("_MyFaces_listenerItem[_MyFaces_listenerItem.length] = _MyFaces_listener;\n");
                }
                writer.write(buff.toString());
                writer.endElement("script");
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception while rendering code for listeners.", (Throwable)e);
        }
    }
}

