/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.htmlTag;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.htmlTag.HtmlTag;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlTagRenderer
extends HtmlRenderer {
    public static final String RENDERER_TYPE = "org.apache.myfaces.HtmlTagRenderer";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlTag htmlTag = (HtmlTag)component;
        if (htmlTag.isRendered()) {
            String tag = htmlTag.getValue().toString();
            if (tag.trim().length() == 0) {
                return;
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(tag, (UIComponent)htmlTag);
            HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)htmlTag, context);
            String[] supportedAttributes = new String[]{"styleClass", "style"};
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)htmlTag, supportedAttributes);
            if (htmlTag.getClass().equals(HtmlTag.class)) {
                Map params = this.getParameterMap((UIComponent)htmlTag);
                for (Map.Entry param : params.entrySet()) {
                    if (null == param.getValue()) continue;
                    writer.writeAttribute(param.getKey().toString(), (Object)param.getValue().toString(), null);
                }
            }
        }
    }

    public Map getParameterMap(UIComponent component) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (UIComponent child : component.getChildren()) {
            UIParameter uiparam;
            Object value;
            if (!child.getClass().equals(UIParameter.class) || (value = (uiparam = (UIParameter)child).getValue()) == null) continue;
            result.put(uiparam.getName(), value);
        }
        return result;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        RendererUtils.renderChildren(context, component);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlTag htmlTag = (HtmlTag)component;
        if (htmlTag.isRendered()) {
            String tag = htmlTag.getValue().toString();
            if (tag.trim().length() == 0) {
                return;
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.endElement(tag);
        }
    }
}

