/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.context;

import java.util.Arrays;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version
implements Comparable<Version> {
    private final String[] _versions;
    private final String _versionPadding;
    private final int _hashCode;
    private static final Pattern _DOT_SPLITTER = Pattern.compile("\\.");

    public Version(String version) {
        this(version, null);
    }

    public Version(String version, String versionPadding) {
        this._checkNonEmptyString(version, "version");
        if (versionPadding == null) {
            versionPadding = "";
        }
        this._versions = _DOT_SPLITTER.split(version, 0);
        this._versionPadding = versionPadding;
        this._hashCode = version.hashCode() * 37 + versionPadding.hashCode();
    }

    @Override
    public int compareTo(Version otherVersion) {
        int ourVersionCount = this._versions.length;
        int otherVersionCount = otherVersion._versions.length;
        int compareCount = ourVersionCount > otherVersionCount ? ourVersionCount : otherVersionCount;
        for (int versionIndex = 0; versionIndex < compareCount; ++versionIndex) {
            int result;
            String ourSubVersion = this._getSubVersion(versionIndex);
            String otherSubVersion = otherVersion._getSubVersion(versionIndex);
            if ("*".equals(ourSubVersion) || "*".equals(otherSubVersion) || (result = ourSubVersion.compareTo(otherSubVersion)) == 0) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder versionBuilder = new StringBuilder();
        int versionCount = this._versions.length;
        int i = 0;
        while (true) {
            versionBuilder.append(this._versions[i]);
            if (++i == versionCount) break;
            versionBuilder.append('.');
        }
        return versionBuilder.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version otherVersion = (Version)o;
        return this._versionPadding.equals(otherVersion._versionPadding) && Arrays.equals(this._versions, otherVersion._versions);
    }

    public int hashCode() {
        return this._hashCode;
    }

    private String _getSubVersion(int versionIndex) {
        if (versionIndex >= this._versions.length) {
            return this._versionPadding;
        }
        return this._versions[versionIndex];
    }

    private void _checkNonEmptyString(String checkedString, String identifier) {
        if (checkedString == null) {
            throw new NullPointerException(identifier + " must be non-null");
        }
        if (checkedString.length() == 0) {
            throw new IllegalArgumentException(identifier + " must be non-empty");
        }
    }
}

