/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputText;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ValueRenderer;
import org.apache.myfaces.trinidadinternal.util.nls.StringUtils;

public class OutputTextRenderer
extends ValueRenderer {
    private PropertyKey _truncateAtKey;
    private PropertyKey _escapeKey;
    private PropertyKey _descriptionKey;

    public OutputTextRenderer() {
        super(CoreOutputText.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._truncateAtKey = type.findKey("truncateAt");
        this._escapeKey = type.findKey("escape");
        this._descriptionKey = type.findKey("description");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        if (this.canSkipRendering(context, arc, comp)) {
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        String value = this.getConvertedString(context, comp, bean);
        boolean escape = this.getEscape(bean);
        if (escape) {
            rw.startElement("span", comp);
            this.renderId(context, comp);
            this.renderAllAttributes(context, arc, bean);
            this._renderDescription(context, arc, bean);
            if (value != null) {
                int truncateAt = this.getTruncateAt(bean);
                if (truncateAt > 0) {
                    value = StringUtils.truncateString(value, truncateAt);
                }
                rw.writeText((Object)value, "value");
            }
            rw.endElement("span");
        } else if (value != null) {
            rw.write(value);
        }
    }

    protected boolean getEscape(FacesBean bean) {
        Object o = bean.getProperty(this._escapeKey);
        if (o == null) {
            o = this._escapeKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    protected int getTruncateAt(FacesBean bean) {
        Object o = bean.getProperty(this._truncateAtKey);
        if (o == null) {
            o = this._truncateAtKey.getDefault();
        }
        return ((Number)o).intValue();
    }

    protected Object getDescription(FacesBean bean) {
        return bean.getProperty(this._descriptionKey);
    }

    private void _renderDescription(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        if (OutputTextRenderer.isInaccessibleMode((RenderingContext)arc)) {
            return;
        }
        Object label = this.getDescription(bean);
        if (label == null) {
            return;
        }
        if (!HiddenLabelUtils.supportsHiddenLabels(arc)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        OutputTextRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"p_OraHiddenLabel");
        writer.writeText(label, null);
        writer.endElement("span");
    }
}

