/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXShowOne;
import org.apache.myfaces.trinidad.component.core.layout.CoreShowDetailItem;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.DisclosureEvent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class ShowDetailItemRenderer
extends XhtmlRenderer {
    private PropertyKey _disclosedKey;

    public ShowDetailItemRenderer() {
        this(CoreShowDetailItem.TYPE);
    }

    protected ShowDetailItemRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._disclosedKey = type.findKey("disclosed");
    }

    public void decode(FacesContext context, UIComponent component) {
        Map parameters = context.getExternalContext().getRequestParameterMap();
        Object event = parameters.get("event");
        if ("hide".equals(event) || "show".equals(event)) {
            Object source = parameters.get("source");
            String id = component.getClientId(context);
            if (id.equals(source)) {
                boolean isDisclosed = "show".equals(event);
                new DisclosureEvent(component, isDisclosed).queue();
                UIComponent pprComponent = component.getParent() instanceof UIXShowOne ? component.getParent() : component;
                RequestContext.getCurrentInstance().addPartialTarget(pprComponent);
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean getDisclosed(FacesBean bean) {
        Object o = bean.getProperty(this._disclosedKey);
        if (o == null) {
            o = this._disclosedKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("span", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        if (this.getDisclosed(bean)) {
            this.encodeAllChildren(context, component);
        }
        rw.endElement("span");
    }
}

