/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidadinternal.convert.ConverterUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public abstract class ValueRenderer
extends XhtmlRenderer {
    private PropertyKey _valueKey;
    private PropertyKey _converterKey;

    protected ValueRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._converterKey = type.findKey("converter");
        this._valueKey = type.findKey("value");
    }

    protected String getConvertedString(FacesContext context, UIComponent component, FacesBean bean) {
        Object value = this.getValue(bean);
        Converter converter = this.getConverter(bean);
        if (converter == null && value != null && !(value instanceof String)) {
            converter = this.getDefaultConverter(context, bean);
        }
        if (converter != null) {
            return converter.getAsString(context, component, value);
        }
        return ValueRenderer.toString((Object)value);
    }

    protected Converter getDefaultConverter(FacesContext context, FacesBean bean) {
        ValueBinding binding = this.getValueBinding(bean);
        if (binding == null) {
            return null;
        }
        Class type = binding.getType(context);
        return ConverterUtils.createConverter(context, type);
    }

    protected Object getValue(FacesBean bean) {
        return bean.getProperty(this._valueKey);
    }

    protected ValueBinding getValueBinding(FacesBean bean) {
        return bean.getValueBinding(this._valueKey);
    }

    protected Converter getConverter(FacesBean bean) {
        return (Converter)bean.getProperty(this._converterKey);
    }
}

