/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib;

import javax.faces.component.UIComponent;
import javax.faces.webapp.FacetTag;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.trinidad.component.UIXComponentRef;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.taglib.ComponentRefTag;

public class FacetRefTag
extends TagSupport {
    private String _facet;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FacetRefTag.class);

    public void setFacetName(String f) {
        this._facet = f;
    }

    public int doStartTag() throws JspException {
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (tag == null) {
            _LOG.warning("FACETREF_MUST_INSIDE_UICOMPONENT");
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        UIComponent region = this._getRegionComponent(component);
        if (region == null) {
            _LOG.warning("CANNOT_FIND_PARENT_COMPONENTREF");
            return 0;
        }
        if (this._facet != null) {
            UIComponent child = region.getFacet(this._facet);
            if (child != null) {
                this._addChild(component, child);
                ComponentRefTag.addRelocatedFacet(region, this._facet, child);
            }
        } else {
            _LOG.warning("FACETNAME_REQUIRED");
        }
        return 0;
    }

    public void release() {
        super.release();
        this._facet = null;
    }

    private void _addChild(UIComponent parent, UIComponent child) {
        String facet = this._getParentFacetName();
        if (facet != null) {
            parent.getFacets().put(facet, child);
        } else {
            parent.getChildren().add(child);
        }
    }

    private String _getParentFacetName() {
        Tag parent = this.getParent();
        if (parent instanceof FacetTag) {
            return ((FacetTag)parent).getName();
        }
        return null;
    }

    private UIComponent _getRegionComponent(UIComponent comp) {
        while ((comp = comp.getParent()) != null && !(comp instanceof UIXComponentRef)) {
        }
        return comp;
    }
}

