/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.util.Vector;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.style.StyleConstants;
import org.apache.myfaces.trinidadinternal.style.xml.XMLConstants;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludeStyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class StyleNodeParser
extends BaseNodeParser
implements XMLConstants,
StyleConstants {
    private String _name;
    private String _selector;
    private boolean _resetProperties;
    private Vector<PropertyNode> _properties;
    private Vector<IncludeStyleNode> _includedStyles;
    private Vector<IncludePropertyNode> _includedProperties;
    private static final String _INCLUDE_STYLE_ID_ERROR = "<includeStyle> element must specify a selector or name attribute";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleNodeParser.class);

    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        this._name = attrs.getValue("name");
        this._selector = attrs.getValue("selector");
        this._resetProperties = "true".equals(attrs.getValue("resetProperties"));
        if (this._name == null && this._selector == null && _LOG.isWarning()) {
            _LOG.warning("ELEMENT_MUST_HAVE_NAME_ATTRIBUTE");
        }
    }

    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if (this._name == null && this._selector == null) {
            return null;
        }
        Object[] properties = null;
        if (this._properties != null) {
            properties = new PropertyNode[this._properties.size()];
            this._properties.copyInto(properties);
        }
        Object[] includedStyles = null;
        if (this._includedStyles != null) {
            includedStyles = new IncludeStyleNode[this._includedStyles.size()];
            this._includedStyles.copyInto(includedStyles);
        }
        Object[] includedProperties = null;
        if (this._includedProperties != null) {
            includedProperties = new IncludePropertyNode[this._includedProperties.size()];
            this._includedProperties.copyInto(includedProperties);
        }
        return new StyleNode(this._name, this._selector, (PropertyNode[])properties, (IncludeStyleNode[])includedStyles, (IncludePropertyNode[])includedProperties, null, this._resetProperties);
    }

    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("property")) {
            return context.getParser(PropertyNode.class, namespaceURI, localName);
        }
        if (localName.equals("includeProperty")) {
            return context.getParser(IncludePropertyNode.class, namespaceURI, localName);
        }
        if (localName.equals("includeStyle")) {
            String name = attrs.getValue("name");
            String selector = attrs.getValue("selector");
            if (name == null && selector == null) {
                _LOG.warning(_INCLUDE_STYLE_ID_ERROR);
            } else {
                if (this._includedStyles == null) {
                    this._includedStyles = new Vector();
                }
                this._includedStyles.addElement(new IncludeStyleNode(name, selector));
            }
            return BaseNodeParser.getIgnoreParser();
        }
        return null;
    }

    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) {
        if (localName.equals("property")) {
            if (child != null) {
                if (this._properties == null) {
                    this._properties = new Vector();
                }
                if (!(child instanceof PropertyNode)) {
                    throw new IllegalArgumentException(_LOG.getMessage("CHILD_NOT_PROPERTYNODE_INSTANCE"));
                }
                if (child instanceof PropertyNode) {
                    this._properties.addElement((PropertyNode)child);
                }
            }
        } else if (localName.equals("includeProperty")) {
            if (!(child instanceof IncludePropertyNode)) {
                throw new IllegalArgumentException(_LOG.getMessage("CHIL_NOT_INCLUDEPROEPRTYNODE_INSTANCE"));
            }
            if (child instanceof IncludePropertyNode) {
                if (this._includedProperties == null) {
                    this._includedProperties = new Vector();
                }
                this._includedProperties.addElement((IncludePropertyNode)child);
            }
        }
    }
}

