/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.parse;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.StringParser;
import org.apache.myfaces.trinidadinternal.skin.parse.SkinNode;
import org.apache.myfaces.trinidadinternal.skin.parse.SkinVersionNode;
import org.apache.myfaces.trinidadinternal.skin.parse.XMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class SkinNodeParser
extends BaseNodeParser
implements XMLConstants {
    private String _namespace;
    private String _id;
    private String _family;
    private String _styleSheetName;
    private String _renderKitId;
    private String _bundleName;
    private String _translationSourceExpression;
    private String _extends;
    private SkinVersionNode _skinVersionNode;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinNodeParser.class);

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        this._namespace = namespaceURI;
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
        if (this._id == null) {
            _LOG.severe("REQUIRED_ELEMENT_ID_NOT_FOUND");
        }
        if (this._family == null) {
            _LOG.severe("REQURIED_ELEMENT_FAMILY_NOT_FOUND");
        }
        if (this._bundleName != null && this._translationSourceExpression != null) {
            _LOG.severe("BOTH_BUNDLENAME_TRANSLATIONSOURCE_SET");
            this._translationSourceExpression = null;
        }
        if (!(this._translationSourceExpression == null || this._translationSourceExpression.startsWith("#{") && this._translationSourceExpression.endsWith("}"))) {
            _LOG.severe("TRANSLATION_SOURCE_NOT_EL");
            this._translationSourceExpression = null;
        }
        return new SkinNode(this._id, this._family, this._renderKitId, this._extends, this._styleSheetName, this._bundleName, this._translationSourceExpression, this._skinVersionNode);
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if (!namespaceURI.equals(this._namespace)) {
            return null;
        }
        if ("id".equals(localName) || "family".equals(localName) || "render-kit-id".equals(localName) || "style-sheet-name".equals(localName) || "bundle-name".equals(localName) || "translation-source".equals(localName) || "extends".equals(localName)) {
            return new StringParser();
        }
        if ("version".equals(localName)) {
            return context.getParser(SkinVersionNode.class, namespaceURI, localName);
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
        if ("id".equals(localName)) {
            this._id = (String)child;
        } else if ("family".equals(localName)) {
            this._family = (String)child;
        } else if ("render-kit-id".equals(localName)) {
            this._renderKitId = (String)child;
        } else if ("style-sheet-name".equals(localName)) {
            this._styleSheetName = (String)child;
        } else if ("bundle-name".equals(localName)) {
            this._bundleName = (String)child;
        } else if ("translation-source".equals(localName)) {
            this._translationSourceExpression = (String)child;
        } else if ("extends".equals(localName)) {
            this._extends = (String)child;
        } else if (child instanceof SkinVersionNode) {
            this._skinVersionNode = (SkinVersionNode)child;
        }
    }
}

