/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.io.CachingInputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.InputStreamProviderProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingNameResolver
implements NameResolver {
    private NameResolver _base;
    private Map<Object, InputStreamProvider> _cachedFiles;
    private int _msBetweenChecks;
    private static final int _DEFAULT_MILLISECONDS_BETWEEN_CHECKS = 1000;
    private static final int _DO_NOT_CHECK_MODIFIED = -1;

    public CachingNameResolver(NameResolver base, Map<Object, InputStreamProvider> storage, boolean checkModified) {
        this(base, storage, checkModified ? 1000 : -1);
    }

    public CachingNameResolver(NameResolver base, Map<Object, InputStreamProvider> storage, int msBetweenChecks) {
        if (base == null) {
            throw new NullPointerException();
        }
        this._base = base;
        if (storage == null) {
            storage = new Hashtable<Object, InputStreamProvider>(197);
        }
        this._cachedFiles = storage;
        this._msBetweenChecks = msBetweenChecks == -1 || msBetweenChecks >= 0 ? msBetweenChecks : 1000;
    }

    public InputStreamProvider getProvider(String name) throws IOException {
        InputStreamProvider provider = this._base.getProvider(name);
        InputStreamProvider cached = this._getCachedProvider(provider.getIdentifier());
        if (cached != null) {
            return cached;
        }
        return new CachingProvider(provider, this._cachedFiles, this._msBetweenChecks);
    }

    public NameResolver getResolver(String name) {
        NameResolver resolver = this._base.getResolver(name);
        return new CachingNameResolver(resolver, this._cachedFiles, this._msBetweenChecks);
    }

    public String toString() {
        return super.toString() + "[" + this._base.toString() + "]";
    }

    private boolean _checkModified() {
        return this._msBetweenChecks != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStreamProvider _getCachedProvider(Object o) {
        Map<Object, InputStreamProvider> map = this._cachedFiles;
        synchronized (map) {
            InputStreamProvider provider = this._cachedFiles.get(o);
            if (provider != null && this._checkModified() && provider.hasSourceChanged()) {
                this._cachedFiles.remove(o);
                provider = null;
            }
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void __addToCache(CachingProvider provider, Map<Object, InputStreamProvider> storage) {
        Map<Object, InputStreamProvider> map = storage;
        synchronized (map) {
            storage.put(provider.getIdentifier(), provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachingProvider
    extends InputStreamProviderProxy
    implements CachingInputStreamProvider {
        private ArrayList<InputStreamProvider> _dependencies;
        private Map<Object, InputStreamProvider> _storage;
        private final InputStreamProvider _wrapped;
        private long _lastChecked = -1L;
        private int _msBetweenChecks;

        public CachingProvider(InputStreamProvider wrapped, Map<Object, InputStreamProvider> storage, int msBetweenChecks) {
            this._wrapped = wrapped;
            this._storage = storage;
            this._msBetweenChecks = msBetweenChecks;
        }

        @Override
        public void setCachedResult(Object value) {
            this._lastChecked = System.currentTimeMillis();
            if (value != null) {
                CachingNameResolver.__addToCache(this, this._storage);
            }
            super.setCachedResult(value);
        }

        @Override
        public boolean hasSourceChanged() {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this._lastChecked < (long)this._msBetweenChecks) {
                return false;
            }
            boolean changed = super.hasSourceChanged();
            if (changed) {
                return true;
            }
            ArrayList<InputStreamProvider> dependencies = this._dependencies;
            if (dependencies != null) {
                for (int i = dependencies.size() - 1; i >= 0; --i) {
                    if (!dependencies.get(i).hasSourceChanged()) continue;
                    return true;
                }
            }
            this._lastChecked = currentTime;
            return false;
        }

        @Override
        public void addCacheDependency(InputStreamProvider dependency) {
            if (dependency == this || dependency == this._wrapped) {
                throw new IllegalArgumentException("Circular dependency - dependency");
            }
            if (dependency == null) {
                return;
            }
            if (this._dependencies == null) {
                this._dependencies = new ArrayList(5);
            }
            this._dependencies.add(dependency);
        }

        @Override
        public Iterator<InputStreamProvider> getCacheDependencies() {
            ArrayList<InputStreamProvider> dependencies = this._dependencies;
            if (dependencies == null) {
                return null;
            }
            return dependencies.iterator();
        }

        @Override
        protected InputStreamProvider getProvider() {
            return this._wrapped;
        }
    }
}

