/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.skin.AgentAtRuleMatcher;
import org.apache.myfaces.trinidadinternal.style.StyleConstants;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.XMLConstants;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetNodeParser
extends BaseNodeParser
implements XMLConstants,
StyleConstants {
    private List<StyleNode> _styles;
    private Set<Locale> _locales;
    private int _direction;
    private int _mode;
    private List<TrinidadAgent.Application> _browsers;
    private Version[] _versions;
    private int[] _platforms;
    private Set<String> _accProperties;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetNodeParser.class);

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        this._locales = this._initLocales(attrs.getValue("locales"));
        this._direction = NameUtils.getDirection(attrs.getValue("direction"));
        this._mode = NameUtils.getMode(attrs.getValue("mode"));
        this._browsers = this._initBrowsers(attrs.getValue("browsers"));
        this._versions = this._initVersions(attrs.getValue("versions"));
        this._platforms = this._initPlatforms(attrs.getValue("platforms"));
        this._accProperties = this._initAccessibilityProperties(attrs.getValue("accessibilityProfile"));
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        StyleNode[] styles = null;
        if (this._styles != null) {
            styles = this._styles.toArray(new StyleNode[this._styles.size()]);
        }
        AgentAtRuleMatcher agentMatcher = this._browsers.isEmpty() ? null : new AgentAtRuleMatcher(this._browsers, this._versions);
        return new StyleSheetNode(styles, null, null, this._locales, this._direction, agentMatcher, this._platforms, this._mode, this._accProperties);
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("style")) {
            return context.getParser(StyleNode.class, namespaceURI, localName);
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) {
        if (child instanceof StyleNode) {
            if (this._styles == null) {
                this._styles = new ArrayList<StyleNode>();
            }
            this._styles.add((StyleNode)child);
        }
    }

    private Set<Locale> _initLocales(String localeAttr) {
        Iterator<String> tokens = this._getTokens(localeAttr);
        if (tokens == null) {
            return Collections.emptySet();
        }
        HashSet<Locale> locales = new HashSet<Locale>();
        while (tokens.hasNext()) {
            String localeString = tokens.next();
            Locale locale = LocaleUtils.getLocaleForIANAString(localeString.replace('_', '-').trim());
            if (locale == null) continue;
            locales.add(locale);
        }
        return locales;
    }

    private List<TrinidadAgent.Application> _initBrowsers(String browserAttr) {
        Iterator<String> browsers = this._getTokens(browserAttr);
        if (browsers == null) {
            return Collections.emptyList();
        }
        ArrayList<TrinidadAgent.Application> applications = new ArrayList<TrinidadAgent.Application>();
        while (browsers.hasNext()) {
            TrinidadAgent.Application browser = NameUtils.getAgentApplication(browsers.next());
            if (browser == TrinidadAgent.Application.UNKNOWN) continue;
            applications.add(browser);
        }
        return applications;
    }

    private Version[] _initVersions(String versionAttr) {
        Iterator<String> versions = this._getTokens(versionAttr);
        if (versions == null) {
            return null;
        }
        ArrayList<Version> v = new ArrayList<Version>();
        while (versions.hasNext()) {
            String version = versions.next();
            if (version == null) continue;
            v.add(new Version(version, "*"));
        }
        return v.toArray(new Version[v.size()]);
    }

    private int[] _initPlatforms(String platformAttr) {
        Iterator<String> platforms = this._getTokens(platformAttr);
        if (platforms == null) {
            return null;
        }
        ArrayList<Integer> v = new ArrayList<Integer>();
        while (platforms.hasNext()) {
            String platformName = platforms.next();
            int platform = NameUtils.getPlatform(platformName);
            if (platform == 0 && "unix".equals(platformName)) {
                platform = Integer.MAX_VALUE;
            }
            if (platform == 0) continue;
            v.add(platform);
        }
        return this._getIntegers(v);
    }

    private Set<String> _initAccessibilityProperties(String accProfileAttr) {
        Iterator<String> tokens = this._getTokens(accProfileAttr);
        if (tokens == null) {
            return Collections.emptySet();
        }
        HashSet<String> props = new HashSet<String>(11);
        while (tokens.hasNext()) {
            String token = tokens.next();
            if (NameUtils.isAccessibilityPropertyName(token)) {
                props.add(token);
                continue;
            }
            _LOG.warning("INVALID_ACC_PROFILE", new Object[]{token});
        }
        return props;
    }

    private int[] _getIntegers(List<Integer> v) {
        int count = v.size();
        if (count == 0) {
            return null;
        }
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = v.get(i);
        }
        return array;
    }

    private Iterator<String> _getTokens(String attr) {
        if (attr == null) {
            return null;
        }
        return Arrays.asList(XMLUtils.parseNameTokens(attr)).iterator();
    }
}

