/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableUtils;

public final class RowData {
    private String _currRowHeaderID = null;
    private final int _rowCount;
    private int _currRowSpan = 1;
    private int _currSpanRow = 0;
    private final CollectionComponent _tableBase;

    public RowData(TableRenderingContext tContext) {
        CollectionComponent table;
        this._tableBase = table = tContext.getCollectionComponent();
        this._rowCount = TableUtils.getVisibleRowCount(table);
    }

    public int getRangeIndex() {
        int first = this._tableBase.getFirst() + 1;
        if (first <= 0) {
            first = 1;
        }
        return this._tableBase.getRowIndex() - first + 1;
    }

    public int getVisibleRowCount() {
        return this._rowCount;
    }

    public boolean isEmptyTable() {
        return this.getVisibleRowCount() <= 0;
    }

    public void setCurrentRowHeaderID(String id) {
        this._currRowHeaderID = id;
    }

    public String getCurrentRowHeaderID() {
        return this._currRowHeaderID;
    }

    public int getCurrentRowSpan() {
        return this._currRowSpan;
    }

    public void setCurrentRowSpan(int rowSpan) {
        if (rowSpan < 0) {
            this._currRowSpan = 1;
            this._currSpanRow = 0;
        } else if (rowSpan > this._currRowSpan) {
            this._currRowSpan = rowSpan;
        }
    }

    public int getCurrentSubRow() {
        assert (this._currSpanRow < this._currRowSpan);
        return this._currSpanRow;
    }

    public void incCurrentSubRow() {
        ++this._currSpanRow;
    }
}

