/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;
import org.apache.myfaces.trinidadinternal.ui.NodeUtils;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.beans.MarlinBean;
import org.apache.myfaces.trinidadinternal.ui.data.BoundValue;
import org.apache.myfaces.trinidadinternal.ui.data.DataBoundValue;
import org.apache.myfaces.trinidadinternal.ui.data.bind.DefaultingBoundValue;
import org.apache.myfaces.trinidadinternal.ui.data.bind.IfBoundValue;
import org.apache.myfaces.trinidadinternal.ui.laf.base.BaseLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.SkinTranslatedBoundValue;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.HtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.FormValueRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.uinode.UIComponentUINode;

@Deprecated
public class TreeRenderer
extends HtmlLafRenderer {
    private static final String _BACKGROUND_IMAGE_URL = "background-image:url(";
    private static final String _END_FUNC = ");";
    private static final UINode _DEFAULT_STAMP = TreeRenderer._createDefaultStamp();
    private static UINode _ICON;
    private static final String _ICON_WIDTH = "16";
    private static final String _ICON_HEIGHT = "22";
    private static final String _NODE_ICON_HEIGHT = "16";
    private static final String _NODE_SPACER = "6";
    protected static final int NO_CHILDREN = 0;
    protected static final int EXPAND_CLOSED = 1;
    protected static final int EXPAND_OPEN = 2;
    protected static final int EXPAND_ALWAYS = 3;
    private static final int _DEFAULT_TREE_DEPTH = 10;
    private static final int _DEFAULT_TREE_INCREMENT = 5;
    private static final Object _JS_RENDERED_KEY;
    static final String _STYLE_CLASS_KEY = "_styleClass";
    private static final String _DISABLED_COLLAPSE_TIP_KEY = "af_tree.DISABLED_COLLAPSE_TIP";
    private static final String _COLLAPSE_TIP_KEY = "af_tree.COLLAPSE_TIP";
    private static final String _EXPAND_TIP_KEY = "af_tree.EXPAND_TIP";
    private static final String _FOLDER_TIP_KEY = "af_tree.FOLDER_TIP";
    private static final String _NODE_LEVEL_TEXT_KEY = "af_tree.NODE_LEVEL";
    private static final String _PATH_PARAM = "path";
    private static final TrinidadLogger _LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        String name = (String)node.getAttributeValue(context, UIConstants.ID_ATTR);
        assert (name != null);
        UIXHierarchy tree = this.getTree(context, node);
        Object oldPath = tree.getRowKey();
        try {
            boolean continueRendering = this.setInitialPath(context, node, tree);
            if (!continueRendering) {
                return;
            }
            this._renderContent(context, node, tree, name);
        }
        finally {
            tree.setRowKey(oldPath);
        }
    }

    private void _renderContent(UIXRenderingContext context, UINode node, UIXHierarchy tree, String name) throws IOException {
        UINode stamp = this.getStamp(context, node);
        if (stamp == null) {
            stamp = _DEFAULT_STAMP;
        }
        Object focusPath = tree.getFocusRowKey();
        String formName = TreeRenderer.getParentFormName(context);
        if (formName == null) {
            _LOG.warning("TREE_COMPONENT_MUST_INSIDE_FORM");
            return;
        }
        String varName = "_adftree" + XhtmlUtils.getJSIdentifier(name);
        boolean leftToRight = !context.getLocaleContext().isRightToLeft();
        int rootSize = tree.getRowCount();
        RowKeySet state = this.getExpandedRowKeys(tree);
        Map<Object, Boolean> selectedPaths = this.getSelectedPaths(focusPath);
        UINode icon = this.getIcon();
        for (int i = 0; i < rootSize; ++i) {
            tree.setRowIndex(i);
            this._renderNode(context, tree, icon, stamp, varName, state, selectedPaths, new Boolean[10], leftToRight, i == 0, i == rootSize - 1, 0);
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        TreeRenderer.renderScriptDeferAttribute(context);
        XhtmlLafRenderer.renderScriptTypeAttribute(context);
        this._renderTreeJS(context, node);
        String selectedParam = name + ':' + "_selected";
        writer.writeText((Object)("var " + varName + " = " + TreeRenderer._createNewJSSelectionState(formName, name, selectedParam)), null);
        writer.endElement("script");
        FormValueRenderer.addNeededValue(context, formName, selectedParam);
        FormValueRenderer.addNeededValue(context, formName, "partialTargets");
        FormValueRenderer.addNeededValue(context, formName, "partial");
        FormValueRenderer.addNeededValue(context, formName, _PATH_PARAM);
    }

    protected UIXHierarchy getTree(UIXRenderingContext context, UINode node) {
        return (UIXHierarchy)node.getUIComponent();
    }

    protected UINode getStamp(UIXRenderingContext context, UINode node) {
        return this.getNamedChild(context, node, "nodeStamp");
    }

    protected boolean setInitialPath(UIXRenderingContext context, UINode node, UIXHierarchy tree) {
        tree.setRowKey(null);
        return true;
    }

    private boolean _isShownSelected(UIXHierarchy tree, Map<Object, Boolean> selectedPaths, Object currPath) {
        boolean selected = false;
        if (tree instanceof UIXTree) {
            selected = ((UIXTree)tree).getSelectedRowKeys().isContained();
        }
        if (selected) {
            return true;
        }
        Boolean value = selectedPaths.get(currPath);
        return value != null;
    }

    protected Map<Object, Boolean> getSelectedPaths(Object focusPath) {
        if (focusPath == null) {
            return new HashMap<Object, Boolean>(0);
        }
        HashMap<Object, Boolean> selectedPaths = new HashMap<Object, Boolean>(1);
        selectedPaths.put(focusPath, Boolean.TRUE);
        return selectedPaths;
    }

    protected RowKeySet getExpandedRowKeys(UIXHierarchy tree) {
        return ((UIXTree)tree).getDisclosedRowKeys();
    }

    protected String getConnectingBackgroundIcon(boolean isLine, boolean leftToRight) {
        return null;
    }

    protected String getIconBackgroundIcon(int expand, boolean isLeftToRight) {
        return null;
    }

    protected void renderExpandCell(UIXRenderingContext context, UIXHierarchy tree, boolean isLeftToRight, boolean isRoot, boolean isLastSibling, int expanded, String onclick) throws IOException {
        Object altText = null;
        String text = null;
        switch (expanded) {
            case 0: {
                break;
            }
            case 1: {
                text = context.getAgent().getAgentOS() == 2 ? (TreeRenderer.isRightToLeft(context) ? "\u2190" : "\u2192") : (TreeRenderer.isRightToLeft(context) ? "\u25c4" : "\u25ba");
                altText = TreeRenderer.getTranslatedValue(context, this.mapKey(_EXPAND_TIP_KEY));
                break;
            }
            case 2: {
                text = context.getAgent().getAgentOS() == 2 ? "\u2193" : "\u25bc";
                altText = TreeRenderer.getTranslatedValue(context, this.mapKey(_COLLAPSE_TIP_KEY));
                break;
            }
            case 3: {
                text = context.getAgent().getAgentOS() == 2 ? "\u2193" : "\u25bc";
                altText = TreeRenderer.getTranslatedValue(context, this.mapKey(_DISABLED_COLLAPSE_TIP_KEY));
            }
        }
        this._renderTextCell(context, text, altText, "16", onclick, "p_OraTreeDisclosedSymbol");
    }

    private void _renderTextCell(UIXRenderingContext context, String text, Object altText, String width, String onclick, Object styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)width, null);
        writer.writeAttribute("title", altText, null);
        TreeRenderer.renderStyleClassAttribute(context, styleClass);
        if (onclick != null) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)onclick, null);
        }
        if (text != null) {
            writer.writeText((Object)text, null);
        }
        if (onclick != null) {
            writer.endElement("a");
        }
        writer.endElement("td");
    }

    protected void renderIconCell(UIXRenderingContext context, UIXHierarchy tree, String backgroundIcon, String icon, boolean isIconAbsoluteURI, Object altText, String width, String height, String onclick) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)width, null);
        if (backgroundIcon != null) {
            String backgroundIconURI = TreeRenderer.getAbsoluteImageURI(context, backgroundIcon);
            writer.writeAttribute("style", (Object)(_BACKGROUND_IMAGE_URL + backgroundIconURI + _END_FUNC), null);
        }
        if (onclick != null) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)onclick, null);
            String treeName = tree.getClientId(context.getFacesContext());
            String id = treeName + ':' + "lnk";
            writer.writeAttribute("id", (Object)id, null);
        }
        this._renderIcon(context, icon, isIconAbsoluteURI, altText, width, height);
        if (onclick != null) {
            writer.endElement("a");
        }
        writer.endElement("td");
    }

    private static String _createNewJSSelectionState(String formName, String treeClientId, String selectParam) {
        return "new _adfTreeSelector('" + selectParam + "'," + TreeUtils.createNewJSCollectionComponentState(formName, treeClientId) + _END_FUNC;
    }

    private static String _callJSSelect(UIXHierarchy tree, String jsVarName) {
        String currencyStr = tree.getClientRowKey();
        return jsVarName + ".select(this,'" + currencyStr + "');";
    }

    private void _renderTreeJS(UIXRenderingContext context, UINode node) throws IOException {
        if (!TreeRenderer.isPreviouslyRendered(context, _JS_RENDERED_KEY)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeText((Object)"function _adfTreeSelector(selectParam,tState) {this._selectParam = selectParam;this._pTag = null;this.treeState = tState;}_adfTreeSelector.prototype.select = function(tag,path) {if (this._pTag != null) {this._pTag.className='p_OraTreeRow';}this._pTag = tag;tag.className='p_OraTreeRowSelected';};", null);
            Object immediate = NodeUtils.getUIComponent(context, node).getAttributes().get("immediate");
            boolean validate = !Boolean.TRUE.equals(immediate);
            String buff = TreeUtils.setupJSTreeCollectionComponent(validate) + ";";
            writer.writeText((Object)buff, null);
        }
    }

    @Override
    protected String getElementName(UIXRenderingContext context, UINode node) {
        return "div";
    }

    private void _renderNode(UIXRenderingContext context, UIXHierarchy tree, UINode icon, UINode stamp, String varName, RowKeySet state, Map<Object, Boolean> selectedPaths, Boolean[] prepend, boolean leftToRight, boolean isFirstSibling, boolean isLastSibling, int nodeDepth) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", null);
        TreeRenderer.renderLayoutTableAttributes(context, ZERO, ZERO, ZERO, null);
        writer.startElement("tr", null);
        this._prependIcons(context, tree, prepend, leftToRight);
        String onclickExpand = null;
        int expand = this._getExpandValue(tree, state);
        if (expand != 0 && TreeRenderer.supportsNavigation(context)) {
            onclickExpand = TreeUtils.callJSExpandNode(tree, varName + ".treeState", expand == 1);
        }
        this.renderExpandCell(context, tree, leftToRight, isFirstSibling, isLastSibling, expand, onclickExpand);
        String treeStyle = "p_OraTreeRow";
        Object currPath = tree.getRowKey();
        boolean selected = this._isShownSelected(tree, selectedPaths, currPath);
        String onClick = TreeRenderer._callJSSelect(tree, varName);
        if (selected) {
            treeStyle = "p_OraTreeRowSelected";
        }
        if (icon != null) {
            String backgroundIcon = this.getIconBackgroundIcon(expand, leftToRight);
            writer.startElement("td", null);
            if (backgroundIcon != null) {
                String backgroundIconURI = TreeRenderer.getAbsoluteImageURI(context, backgroundIcon);
                StringBuffer backgroundStyle = new StringBuffer(_BACKGROUND_IMAGE_URL.length() + backgroundIconURI.length() + _END_FUNC.length());
                backgroundStyle.append(_BACKGROUND_IMAGE_URL);
                backgroundStyle.append(backgroundIconURI);
                backgroundStyle.append(_END_FUNC);
                writer.writeAttribute("style", (Object)backgroundStyle.toString(), null);
            }
            icon.render(context);
            writer.endElement("td");
            this.renderIconCell(context, tree, null, "t.gif", false, null, _NODE_SPACER, _ICON_HEIGHT, null);
        }
        writer.startElement("td", null);
        writer.writeAttribute("nowrap", (Object)Boolean.FALSE, null);
        TreeRenderer.renderStyleClassAttribute(context, "p_OraTreeNodeAdjust");
        writer.startElement("span", null);
        TreeRenderer.renderStyleClassAttribute(context, treeStyle);
        writer.writeAttribute("onclick", (Object)onClick, null);
        this._renderStampBasedOnAccessibilty(context, stamp, nodeDepth);
        writer.endElement("span");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        if (expand == 2 || expand == 3) {
            tree.enterContainer();
            int childCount = tree.getRowCount();
            if (childCount > 0) {
                prepend = this._appendIcon(prepend, isLastSibling ? Boolean.FALSE : Boolean.TRUE);
                ++nodeDepth;
                int oldIndex = tree.getRowIndex();
                for (int i = 0; i < childCount; ++i) {
                    Boolean[] currClone = new Boolean[prepend.length];
                    System.arraycopy(prepend, 0, currClone, 0, prepend.length);
                    tree.setRowIndex(i);
                    this._renderNode(context, tree, icon, stamp, varName, state, selectedPaths, currClone, leftToRight, false, i == childCount - 1, nodeDepth);
                }
                tree.setRowIndex(oldIndex);
                --nodeDepth;
            }
            tree.exitContainer();
        }
    }

    private int _getExpandValue(UIXHierarchy tree, RowKeySet state) {
        if (tree.isContainer()) {
            if (state.isContained()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private void _renderIcon(UIXRenderingContext context, String icon, boolean isIconAbsoluteURI, Object text, String width, String height) throws IOException {
        if (icon != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("img", null);
            TreeRenderer.renderStyleClassAttribute(context, "p_OraTreeIcon");
            writer.writeAttribute("width", (Object)width, null);
            writer.writeAttribute("height", (Object)height, null);
            if (isIconAbsoluteURI) {
                this.renderEncodedResourceURI(context, "src", icon);
            } else {
                TreeRenderer.writeAbsoluteImageURI(context, "src", icon);
            }
            TreeRenderer.renderAltAndTooltipForImage(context, text == null ? "" : text);
            writer.writeAttribute("border", (Object)ZERO, null);
            writer.endElement("img");
        }
    }

    private Boolean[] _appendIcon(Boolean[] prepend, Boolean isLine) {
        int currLength = prepend.length;
        if (prepend[currLength - 1] != null) {
            Boolean[] newBools = new Boolean[currLength + 5];
            System.arraycopy(prepend, 0, newBools, 0, currLength);
            prepend = newBools;
        }
        for (int i = 0; i < currLength; ++i) {
            if (prepend[i] != null) continue;
            prepend[i] = isLine;
            break;
        }
        return prepend;
    }

    private void _prependIcons(UIXRenderingContext context, UIXHierarchy tree, Boolean[] prepend, boolean leftToRight) throws IOException {
        for (Boolean isLine : prepend) {
            if (isLine == null) continue;
            String icon = "t.gif";
            String backgroundIcon = this.getConnectingBackgroundIcon(isLine, leftToRight);
            this.renderIconCell(context, tree, backgroundIcon, icon, false, null, "16", _ICON_HEIGHT, null);
        }
    }

    protected UINode getIcon() {
        if (_ICON != null) {
            return _ICON;
        }
        _ICON = this._createIcon();
        return _ICON;
    }

    protected String getDefaultIconName() {
        return null;
    }

    private UINode _createIcon() {
        BoundValue isExpandable = new BoundValue(){

            @Override
            public Object getValue(UIXRenderingContext rc) {
                UINode uinode = rc.getAncestorNode(1);
                UIXHierarchy tree = (UIXHierarchy)((UIComponentUINode)uinode).getUIComponent();
                return tree.isContainer() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        TreeImageURIBoundValue defaultURI = new TreeImageURIBoundValue(this.getDefaultIconName());
        IfBoundValue defaultIcon = new IfBoundValue(isExpandable, (BoundValue)defaultURI, null);
        DataBoundValue specifiedIcon = new DataBoundValue("icon");
        DefaultingBoundValue iconSource = new DefaultingBoundValue((BoundValue)specifiedIcon, defaultIcon);
        SkinTranslatedBoundValue defaultIconShortDesc = new SkinTranslatedBoundValue(this.mapKey(_FOLDER_TIP_KEY));
        DataBoundValue specifiedIconShortDesc = new DataBoundValue("iconShortDesc");
        DefaultingBoundValue iconShortDesc = new DefaultingBoundValue((BoundValue)specifiedIconShortDesc, defaultIconShortDesc);
        MarlinBean icon = new MarlinBean("image");
        icon.setAttributeValue(SOURCE_ATTR, iconSource);
        icon.setAttributeValue(STYLE_CLASS_ATTR, "p_OraTreeIcon");
        icon.setAttributeValue(WIDTH_ATTR, "16");
        icon.setAttributeValue(HEIGHT_ATTR, "16");
        icon.setAttributeValue(SHORT_DESC_ATTR, iconShortDesc);
        return icon;
    }

    private static UINode _createDefaultStamp() {
        MarlinBean link = new MarlinBean("link");
        link.setAttributeValue(TEXT_ATTR, new DataBoundValue("text"));
        link.setAttributeValue(DESTINATION_ATTR, "destination");
        link.setAttributeValue(TARGET_FRAME_ATTR, new DataBoundValue("targetFrame"));
        return link;
    }

    private void _renderStampBasedOnAccessibilty(UIXRenderingContext context, UINode node, int depth) throws IOException {
        if (TreeRenderer.isScreenReaderMode(context)) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            FacesContext fc = FacesContext.getCurrentInstance();
            if (TreeRenderer.isRightToLeft(context)) {
                node.render(context);
                TreeUtils.writeNodeLevel(fc, arc, depth, this.mapKey(_NODE_LEVEL_TEXT_KEY));
            } else {
                TreeUtils.writeNodeLevel(fc, arc, depth, this.mapKey(_NODE_LEVEL_TEXT_KEY));
                node.render(context);
            }
        } else {
            node.render(context);
        }
    }

    protected String mapKey(String key) {
        return key;
    }

    static {
        _JS_RENDERED_KEY = new Object();
        _LOG = TrinidadLogger.createTrinidadLogger(TreeRenderer.class);
    }

    @Deprecated
    public static class TreeImageURIBoundValue
    implements BoundValue {
        private String _imageName;

        public TreeImageURIBoundValue(String imageName) {
            this._imageName = imageName;
        }

        @Override
        public Object getValue(UIXRenderingContext context) {
            return BaseLafRenderer.getAbsoluteImageURI(context, this._imageName);
        }
    }
}

