/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.util.CollectionUtils;

public class ValueMap
extends AbstractMap<String, Object> {
    private FacesBean _bean;

    public ValueMap(FacesBean bean) {
        this._bean = bean;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        PropertyKey propertyKey = this._getPropertyKey(key);
        if (propertyKey.isList()) {
            Class<?> type = propertyKey.getType();
            if (type.isArray()) {
                type = type.getComponentType();
            }
            return this._bean.getEntries(propertyKey, type);
        }
        Object val = this._bean.getProperty(propertyKey);
        return val != null ? val : propertyKey.getDefault();
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this._putInternal(this._getPropertyKey(key), value);
    }

    @Override
    public Object remove(Object key) {
        PropertyKey propertyKey = this._getPropertyKey(key);
        Object oldValue = this._bean.getProperty(propertyKey);
        this._bean.setProperty(propertyKey, null);
        return oldValue;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        PropertyKey propertyKey = this._getPropertyKey(key);
        return this._bean.getRawProperty(propertyKey) != null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return CollectionUtils.overlappingCompositeSet(new MakeEntries(this._bean.keySet()), new MakeEntries(this._bean.bindingKeySet()));
    }

    private Object _putInternal(PropertyKey propertyKey, Object value) {
        assert (propertyKey != null);
        Object oldValue = this._bean.getProperty(propertyKey);
        this._bean.setProperty(propertyKey, value);
        return oldValue;
    }

    private PropertyKey _getPropertyKey(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            PropertyKey propertyKey = this._bean.getType().findKey(keyString);
            if (propertyKey == null) {
                propertyKey = PropertyKey.getDefaultPropertyKey(keyString);
            }
            return propertyKey;
        }
        if (key instanceof PropertyKey) {
            return (PropertyKey)key;
        }
        throw new ClassCastException();
    }

    private class EntryImpl
    implements Map.Entry<String, Object> {
        private final PropertyKey _key;

        public EntryImpl(PropertyKey key) {
            assert (key != null);
            this._key = key;
        }

        @Override
        public String getKey() {
            return this._key.getName();
        }

        @Override
        public Object getValue() {
            return ValueMap.this.get(this._key);
        }

        @Override
        public Object setValue(Object value) {
            return ValueMap.this._putInternal(this._key, value);
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            Object value = this.getValue();
            return this._key.hashCode() ^ (value == null ? 0 : value.hashCode());
        }
    }

    private class MakeEntries
    extends AbstractSet<Map.Entry<String, Object>> {
        private final Set<PropertyKey> _keys;

        public MakeEntries(Set<PropertyKey> keys) {
            this._keys = keys;
        }

        @Override
        public int size() {
            return this._keys.size();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            final Iterator<PropertyKey> base = this._keys.iterator();
            return new Iterator<Map.Entry<String, Object>>(){
                private EntryImpl _lastEntry;

                @Override
                public boolean hasNext() {
                    return base.hasNext();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    this._lastEntry = new EntryImpl((PropertyKey)base.next());
                    return this._lastEntry;
                }

                @Override
                public void remove() {
                    if (this._lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    base.remove();
                    this._lastEntry = null;
                }
            };
        }
    }
}

