/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelHorizontalLayout;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class PanelHorizontalLayoutRenderer
extends XhtmlRenderer {
    private PropertyKey _valignKey;
    private PropertyKey _halignKey;

    public PanelHorizontalLayoutRenderer() {
        this(CorePanelHorizontalLayout.TYPE);
    }

    protected PanelHorizontalLayoutRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._valignKey = type.findKey("valign");
        this._halignKey = type.findKey("halign");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        Object valign = this.getValign(component, bean);
        Object halign = this.getHalign(component, bean);
        rw.startElement("table", component);
        OutputUtils.renderLayoutTableAttributes(context, rc, "0", null);
        if ("center".equals(halign)) {
            rw.writeAttribute("align", (Object)"center", "halign");
        }
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        rw.startElement("tr", null);
        this._encodeChildren(context, rc, component, valign, halign);
        rw.endElement("tr");
        rw.endElement("table");
    }

    protected Object getValign(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._valignKey);
    }

    protected Object getHalign(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._halignKey);
    }

    private void _encodeChildren(FacesContext context, RenderingContext rc, UIComponent component, Object vAlign, Object hAlign) throws IOException {
        UIComponent separator = PanelHorizontalLayoutRenderer.getFacet((UIComponent)component, (String)"separator");
        boolean needSeparator = false;
        boolean isFirstChild = true;
        boolean isEndAlignment = PanelHorizontalLayoutRenderer.isPDA((RenderingContext)rc) ? false : ("end".equals(hAlign) ? true : ("left".equals(hAlign) ? rc.isRightToLeft() : ("right".equals(hAlign) ? !rc.isRightToLeft() : false)));
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (isFirstChild) {
                isFirstChild = false;
                if (isEndAlignment) {
                    ResponseWriter rw = context.getResponseWriter();
                    rw.startElement("td", null);
                    rw.writeAttribute("width", (Object)"100%", null);
                    rw.endElement("td");
                }
            }
            if (needSeparator) {
                this.encodeSeparator(context, separator, vAlign);
            }
            this.encodeChild(context, child, vAlign);
            needSeparator = true;
        }
    }

    protected void encodeChild(FacesContext context, UIComponent child, Object vAlign) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("td", null);
        rw.writeAttribute("valign", vAlign, null);
        this.encodeChild(context, child);
        rw.endElement("td");
    }

    protected void encodeSeparator(FacesContext context, UIComponent separator, Object vAlign) throws IOException {
        if (separator != null) {
            this.encodeChild(context, separator, vAlign);
        }
    }
}

