/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXShowOne;
import org.apache.myfaces.trinidad.component.core.layout.CoreShowDetailItem;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.DisclosureEvent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class ShowDetailItemRenderer
extends XhtmlRenderer {
    private PropertyKey _disclosedKey;

    public ShowDetailItemRenderer() {
        this(CoreShowDetailItem.TYPE);
    }

    protected ShowDetailItemRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._disclosedKey = type.findKey("disclosed");
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        Object event = parameters.get("event");
        if ("hide".equals(event) || "show".equals(event)) {
            String id;
            Object source = parameters.get("source");
            String string = id = clientId == null ? component.getClientId(facesContext) : clientId;
            if (id.equals(source)) {
                boolean isDisclosed = "show".equals(event);
                new DisclosureEvent(component, isDisclosed).queue();
                UIComponent pprComponent = component.getParent() instanceof UIXShowOne ? component.getParent() : component;
                RequestContext.getCurrentInstance().addPartialTarget(pprComponent);
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean getDisclosed(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._disclosedKey);
        if (o == null) {
            o = this._disclosedKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("span", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        if (this.getDisclosed(component, bean)) {
            this.encodeAllChildren(context, component);
        }
        rw.endElement("span");
    }
}

