/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.text.Document;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.DocTrees;
import jpt.sun.source.util.JavacTask;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt.sun.tools.javac.api.JavacTrees;
import jpt.sun.tools.javac.code.Source;
import jpt.sun.tools.javac.main.JavaCompiler;
import jpt.sun.tools.javac.model.JavacElements;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.util.Elements;
import jpt30.lang.model.util.Types;
import jpt30.tools.Diagnostic;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.preprocessorbridge.spi.WrapperFactory;
import org.netbeans.modules.java.source.CompilationInfoAccessor;
import org.netbeans.modules.java.source.ElementUtils;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class CompilationInfo {
    private static final boolean VERIFY_CONFINEMENT = Boolean.getBoolean(CompilationInfo.class.getName() + ".vetifyConfinement");
    final CompilationInfoImpl impl;
    private boolean invalid;
    private Trees trees;
    private ElementUtilities elementUtilities;
    private TreeUtilities treeUtilities;
    private TypeUtilities typeUtilities;
    private JavaSource javaSource;

    CompilationInfo(CompilationInfoImpl impl) {
        assert (impl != null);
        this.impl = impl;
    }

    @NullUnknown
    public static CompilationInfo get(@NonNull Parser.Result result) {
        Parameters.notNull("result", result);
        CompilationInfo info = null;
        if (result instanceof JavacParserResult) {
            JavacParserResult javacResult = (JavacParserResult)result;
            info = javacResult.get(CompilationInfo.class);
        }
        return info;
    }

    @NonNull
    public JavaSource.Phase getPhase() {
        this.checkConfinement();
        return this.impl.getPhase();
    }

    @CheckForNull
    @CheckReturnValue
    public TreePath getChangedTree() {
        this.checkConfinement();
        if (JavaSource.Phase.PARSED.compareTo(this.impl.getPhase()) > 0) {
            return null;
        }
        Pair<DocPositionRegion, MethodTree> changedTree = this.impl.getChangedTree();
        if (changedTree == null) {
            return null;
        }
        CompilationUnitTree cu = this.impl.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        return TreePath.getPath(cu, (Tree)changedTree.second());
    }

    public CompilationUnitTree getCompilationUnit() {
        this.checkConfinement();
        return this.impl.getCompilationUnit();
    }

    @NonNull
    public String getText() {
        this.checkConfinement();
        return this.impl.getText();
    }

    @NonNull
    public Snapshot getSnapshot() {
        this.checkConfinement();
        return this.impl.getSnapshot();
    }

    @NonNull
    public TokenHierarchy<?> getTokenHierarchy() {
        this.checkConfinement();
        return this.impl.getTokenHierarchy();
    }

    @NonNull
    public List<Diagnostic> getDiagnostics() {
        this.checkConfinement();
        return this.impl.getDiagnostics();
    }

    @NullUnknown
    public List<? extends TypeElement> getTopLevelElements() throws IllegalStateException {
        this.checkConfinement();
        if (this.impl.getFileObject() == null) {
            throw new IllegalStateException();
        }
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        if (this.impl.isClassFile()) {
            JavacElements elements = (JavacElements)this.getElements();
            assert (elements != null);
            assert (this.impl.getRoot() != null);
            String name = FileObjects.convertFolder2Package(FileObjects.stripExtension(FileUtil.getRelativePath(this.impl.getRoot(), this.impl.getFileObject())));
            TypeElement e = Optional.ofNullable(SourceVersion.RELEASE_9.compareTo(this.getSourceVersion()) <= 0 ? SourceUtils.getModuleName(this.impl.getRoot().toURL(), true) : null).map(elements::getModuleElement).map(module -> ElementUtils.getTypeElementByBinaryName(this, (ModuleElement)module, name)).orElseGet(() -> ElementUtils.getTypeElementByBinaryName(this, name));
            if (e != null) {
                result.add(e);
            }
        } else {
            CompilationUnitTree cu = this.getCompilationUnit();
            if (cu == null) {
                return null;
            }
            Trees ts = this.getTrees();
            assert (ts != null);
            List<? extends Tree> typeDecls = cu.getTypeDecls();
            TreePath cuPath = new TreePath(cu);
            for (Tree tree : typeDecls) {
                TreePath p = new TreePath(cuPath, tree);
                Element e = ts.getElement(p);
                if (e == null || !e.getKind().isClass() && !e.getKind().isInterface()) continue;
                result.add((TypeElement)e);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @NonNull
    public synchronized Trees getTrees() {
        this.checkConfinement();
        if (this.trees == null) {
            WrapperFactory factory;
            JavaCompiler.instance(this.impl.getJavacTask().getContext());
            this.trees = JavacTrees.instance(this.impl.getJavacTask().getContext());
            Snapshot snapshot = this.impl.getSnapshot();
            Document doc = snapshot != null ? snapshot.getSource().getDocument(false) : null;
            WrapperFactory wrapperFactory = factory = doc != null ? (WrapperFactory)doc.getProperty(WrapperFactory.class) : null;
            if (factory != null) {
                this.trees = factory.wrapTrees(this.trees);
            }
        }
        return this.trees;
    }

    @NonNull
    public DocTrees getDocTrees() {
        Trees ts = this.getTrees();
        return ts instanceof DocTrees ? (DocTrees)ts : JavacTrees.instance(this.impl.getJavacTask().getContext());
    }

    @NonNull
    public Types getTypes() {
        this.checkConfinement();
        JavaCompiler.instance(this.impl.getJavacTask().getContext());
        return this.impl.getJavacTask().getTypes();
    }

    @NonNull
    public Elements getElements() {
        this.checkConfinement();
        JavaCompiler.instance(this.impl.getJavacTask().getContext());
        return this.impl.getJavacTask().getElements();
    }

    @NullUnknown
    public JavaSource getJavaSource() {
        this.checkConfinement();
        return this.javaSource;
    }

    void setJavaSource(JavaSource javaSource) {
        this.javaSource = javaSource;
    }

    @NonNull
    public ClasspathInfo getClasspathInfo() {
        this.checkConfinement();
        return this.impl.getClasspathInfo();
    }

    @NullUnknown
    public FileObject getFileObject() {
        this.checkConfinement();
        return this.impl.getFileObject();
    }

    @Deprecated
    public PositionConverter getPositionConverter() {
        this.checkConfinement();
        if (this.impl.getFileObject() == null) {
            throw new IllegalStateException();
        }
        return new PositionConverter(this.impl.getSnapshot());
    }

    @CheckForNull
    public Document getDocument() throws IOException {
        this.checkConfinement();
        return this.impl.getDocument();
    }

    @NonNull
    public synchronized TreeUtilities getTreeUtilities() {
        this.checkConfinement();
        if (this.treeUtilities == null) {
            this.treeUtilities = new TreeUtilities(this);
        }
        return this.treeUtilities;
    }

    @NonNull
    public synchronized ElementUtilities getElementUtilities() {
        this.checkConfinement();
        if (this.elementUtilities == null) {
            this.elementUtilities = new ElementUtilities(this);
        }
        return this.elementUtilities;
    }

    @NonNull
    public synchronized TypeUtilities getTypeUtilities() {
        this.checkConfinement();
        if (this.typeUtilities == null) {
            this.typeUtilities = new TypeUtilities(this);
        }
        return this.typeUtilities;
    }

    @NonNull
    public SourceVersion getSourceVersion() {
        this.checkConfinement();
        return Source.toSourceVersion(Source.instance(this.impl.getJavacTask().getContext()));
    }

    @CheckForNull
    public Object getCachedValue(@NonNull Object key) {
        Parameters.notNull("key", key);
        return this.impl.getCachedValue(key);
    }

    public void putCachedValue(@NonNull Object key, @NullAllowed Object value, @NonNull CacheClearPolicy clearPolicy) {
        Parameters.notNull("key", key);
        Parameters.notNull("clearPolicy", (Object)clearPolicy);
        this.impl.putCachedValue(key, value, clearPolicy);
    }

    final void invalidate() {
        this.invalid = true;
        this.impl.taskFinished();
        this.doInvalidate();
    }

    protected void doInvalidate() {
        JavacParser parser = this.impl.getParser();
        if (parser != null) {
            parser.resultFinished(true);
        }
    }

    final void checkConfinement() throws IllegalStateException {
        if (VERIFY_CONFINEMENT && this.invalid) {
            throw new IllegalStateException(String.format("Access to the shared %s outside a guarded run method.", this.getClass().getSimpleName()));
        }
    }

    static {
        CompilationInfoAccessor.setInstance(new CompilationInfoAccessor(){

            @Override
            public JavacTask getJavacTask(CompilationInfo info) {
                return info.impl.getJavacTask();
            }

            @Override
            public CompilationInfoImpl getCompilationInfoImpl(CompilationInfo info) {
                return info.impl;
            }
        });
    }

    public static enum CacheClearPolicy {
        ON_TASK_END,
        ON_CHANGE,
        ON_SIGNATURE_CHANGE;

    }
}

