/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.service.BootstrapCodec;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.util.LimitingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiNiFiListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiNiFiListener.class);
    private Listener listener;
    private ServerSocket serverSocket;

    public int start(RunMiNiFi runner, BootstrapFileProvider bootstrapFileProvider, ConfigurationChangeListener configurationChangeListener) throws IOException {
        this.serverSocket = new ServerSocket();
        this.serverSocket.bind(new InetSocketAddress("localhost", 0));
        this.listener = new Listener(this.serverSocket, new BootstrapCodec(runner, bootstrapFileProvider, configurationChangeListener));
        Thread listenThread = new Thread(this.listener);
        listenThread.setName("MiNiFi listener");
        listenThread.setDaemon(true);
        listenThread.start();
        return this.serverSocket.getLocalPort();
    }

    public void stop() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to close socket");
        }
        Optional.ofNullable(this.listener).ifPresent(Listener::stop);
    }

    private static class Listener
    implements Runnable {
        private final ServerSocket serverSocket;
        private final ExecutorService executor;
        private volatile boolean stopped = false;
        private final BootstrapCodec codec;

        public Listener(ServerSocket serverSocket, BootstrapCodec bootstrapCodec) {
            this.serverSocket = serverSocket;
            this.codec = bootstrapCodec;
            this.executor = Executors.newFixedThreadPool(2, runnable -> {
                Thread t = Executors.defaultThreadFactory().newThread(runnable);
                t.setDaemon(true);
                t.setName("MiNiFi Bootstrap Command Listener");
                return t;
            });
        }

        public void stop() {
            this.stopped = true;
            try {
                this.executor.shutdown();
                try {
                    if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                        this.executor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Failed to stop the MiNiFi listener executor", (Throwable)e);
                    this.executor.shutdownNow();
                }
                this.serverSocket.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close socket", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to stop the MiNiFi listener executor", (Throwable)e);
            }
        }

        @Override
        public void run() {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket socket;
                    if (this.stopped) {
                        return;
                    }
                    try {
                        socket = this.serverSocket.accept();
                    }
                    catch (IOException ioe) {
                        if (this.stopped) {
                            return;
                        }
                        throw ioe;
                    }
                    this.executor.submit(() -> {
                        try (LimitingInputStream limitingIn = new LimitingInputStream(socket.getInputStream(), 4096L);){
                            this.codec.communicate(limitingIn, socket.getOutputStream());
                        }
                        catch (Exception t) {
                            LOGGER.error("Failed to communicate with MiNiFi due to exception: ", (Throwable)t);
                        }
                        finally {
                            try {
                                socket.close();
                            }
                            catch (IOException ioe) {
                                LOGGER.warn("Failed to close the socket ", (Throwable)ioe);
                            }
                        }
                    });
                }
                catch (Exception t) {
                    LOGGER.error("Failed to receive information from MiNiFi due to exception: ", (Throwable)t);
                }
            }
        }
    }
}

