/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.fastdouble;

import io.questdb.std.NumericException;
import io.questdb.std.fastdouble.FastDouble;
import io.questdb.std.fastdouble.FastDoubleByteArray;
import io.questdb.std.fastdouble.FastDoubleCharArray;
import io.questdb.std.fastdouble.FastDoubleMem;

public final class FastDoubleParser {
    private FastDoubleParser() {
    }

    public static double parseDouble(CharSequence str, boolean rejectOverflow) throws NumericException {
        return FastDoubleParser.parseDouble(str, 0, str.length(), rejectOverflow);
    }

    public static double parseDouble(CharSequence str, int offset, int length) throws NumericException {
        return FastDoubleParser.parseDouble(str, offset, length, false);
    }

    public static double parseDouble(CharSequence str, int offset, int length, boolean rejectOverflow) throws NumericException {
        return FastDouble.parseFloatingPointLiteral(str, offset, length, rejectOverflow);
    }

    public static double parseDouble(byte[] str, boolean rejectOverflow) throws NumericException {
        return FastDoubleParser.parseDouble(str, 0, str.length, rejectOverflow);
    }

    public static double parseDouble(long str, int len, boolean rejectOverflow) throws NumericException {
        return FastDoubleParser.parseDouble(str, 0, len, rejectOverflow);
    }

    public static double parseDouble(byte[] str, int offset, int length, boolean rejectOverflow) throws NumericException {
        return FastDoubleByteArray.parseFloatingPointLiteral(str, offset, length, rejectOverflow);
    }

    public static double parseDouble(long str, int offset, int length, boolean rejectOverflow) throws NumericException {
        return FastDoubleMem.parseFloatingPointLiteral(str, offset, length, rejectOverflow);
    }

    public static double parseDouble(char[] str, boolean rejectOverflow) throws NumericException {
        return FastDoubleParser.parseDouble(str, 0, str.length, rejectOverflow);
    }

    public static double parseDouble(char[] str, int offset, int length, boolean rejectOverflow) throws NumericException {
        return FastDoubleCharArray.parseFloatingPointLiteral(str, offset, length, rejectOverflow);
    }
}

