/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.ThreadLocal;
import io.questdb.std.str.AbstractCharSequence;

public class FileNameExtractorCharSequence
extends AbstractCharSequence {
    private static final ThreadLocal<FileNameExtractorCharSequence> SINGLETON = new ThreadLocal<FileNameExtractorCharSequence>(FileNameExtractorCharSequence::new);
    private static final char separator = System.getProperty("file.separator").charAt(0);
    private CharSequence base;
    private int hi;
    private int lo;

    public static CharSequence get(CharSequence that) {
        return SINGLETON.get().of(that);
    }

    @Override
    public char charAt(int index) {
        return this.base.charAt(this.lo + index);
    }

    @Override
    public int length() {
        return this.hi - this.lo;
    }

    public CharSequence of(CharSequence base) {
        this.base = base;
        this.hi = base.length();
        this.lo = 0;
        for (int i = this.hi - 1; i > -1; --i) {
            if (base.charAt(i) != separator) continue;
            this.lo = i + 1;
            break;
        }
        return this;
    }
}

