/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.controller.repository.ActiveProcessSessionFactory;
import org.apache.nifi.processor.exception.TerminatedTaskException;

public class LifecycleState {
    private final AtomicInteger activeThreadCount = new AtomicInteger(0);
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final Set<ScheduledFuture<?>> futures = new HashSet();
    private final AtomicBoolean mustCallOnStoppedMethods = new AtomicBoolean(false);
    private volatile long lastStopTime = -1L;
    private volatile boolean terminated = false;
    private final Map<ActiveProcessSessionFactory, Object> activeProcessSessionFactories = new WeakHashMap<ActiveProcessSessionFactory, Object>();

    public synchronized boolean tryIncrementActiveThreadCount(ActiveProcessSessionFactory sessionFactory) {
        if (this.terminated || !this.scheduled.get()) {
            return false;
        }
        this.incrementActiveThreadCount(sessionFactory);
        return true;
    }

    public synchronized int incrementActiveThreadCount(ActiveProcessSessionFactory sessionFactory) {
        if (this.terminated) {
            throw new TerminatedTaskException();
        }
        if (sessionFactory != null) {
            this.activeProcessSessionFactories.put(sessionFactory, null);
        }
        return this.activeThreadCount.incrementAndGet();
    }

    public synchronized int decrementActiveThreadCount() {
        if (this.terminated) {
            return this.activeThreadCount.get();
        }
        return this.activeThreadCount.decrementAndGet();
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount.get();
    }

    public boolean isScheduled() {
        return this.scheduled.get();
    }

    public synchronized void setScheduled(boolean scheduled) {
        this.scheduled.set(scheduled);
        this.mustCallOnStoppedMethods.set(true);
        if (!scheduled) {
            this.lastStopTime = System.currentTimeMillis();
        }
    }

    public long getLastStopTime() {
        return this.lastStopTime;
    }

    public String toString() {
        return "LifecycleState[activeThreads= " + this.activeThreadCount.get() + ", scheduled=" + this.scheduled.get() + "]";
    }

    public boolean mustCallOnStoppedMethods() {
        return this.mustCallOnStoppedMethods.getAndSet(false);
    }

    public synchronized void setFutures(Collection<ScheduledFuture<?>> newFutures) {
        this.futures.clear();
        this.futures.addAll(newFutures);
    }

    public synchronized void replaceFuture(ScheduledFuture<?> oldFuture, ScheduledFuture<?> newFuture) {
        this.futures.remove(oldFuture);
        this.futures.add(newFuture);
    }

    public synchronized Set<ScheduledFuture<?>> getFutures() {
        return Collections.unmodifiableSet(this.futures);
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.activeThreadCount.set(0);
        for (ActiveProcessSessionFactory factory : this.activeProcessSessionFactories.keySet()) {
            factory.terminateActiveSessions();
        }
    }

    public void clearTerminationFlag() {
        this.terminated = false;
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

