/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.ContextualBitmapImpl;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.ContextualStoreImpl;
import jetbrains.exodus.env.ContextualTemporaryEmptyStore;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionalComputable;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.tree.TreeMetaInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextualEnvironmentImpl
extends EnvironmentImpl
implements ContextualEnvironment {
    private final Map<Thread, Deque<TransactionBase>> threadTxns = new ConcurrentHashMap<Thread, Deque<TransactionBase>>(4, 0.75f, 4);

    ContextualEnvironmentImpl(@NotNull Log log, @NotNull EnvironmentConfig ec) {
        super(log, ec);
    }

    @Nullable
    public TransactionBase getCurrentTransaction() {
        Thread thread = Thread.currentThread();
        Deque<TransactionBase> stack = this.threadTxns.get(thread);
        return stack == null ? null : stack.peek();
    }

    @NotNull
    public Transaction getAndCheckCurrentTransaction() {
        TransactionBase txn = this.getCurrentTransaction();
        if (txn == null) {
            throw new IllegalStateException("No transaction started in current thread");
        }
        return txn;
    }

    @NotNull
    public List<String> getAllStoreNames() {
        return this.getAllStoreNames(this.getAndCheckCurrentTransaction());
    }

    @NotNull
    public ContextualBitmapImpl openBitmap(@NotNull String name, @NotNull StoreConfig config) {
        if (config == StoreConfig.WITH_DUPLICATES || config == StoreConfig.WITH_DUPLICATES_WITH_PREFIXING) {
            throw new ExodusException("Bitmap can't be opened on the store with duplicates");
        }
        ContextualStoreImpl store = this.openStore(name.concat("#bitmap"), config);
        return new ContextualBitmapImpl(store);
    }

    @NotNull
    public ContextualStoreImpl openStore(@NotNull String name, @NotNull StoreConfig config) {
        return (ContextualStoreImpl)super.computeInTransaction(txn -> this.openStore(name, config, txn));
    }

    @Nullable
    public ContextualStoreImpl openStore(@NotNull String name, @NotNull StoreConfig config, boolean creationRequired) {
        return (ContextualStoreImpl)super.computeInTransaction(txn -> this.openStore(name, config, txn, creationRequired));
    }

    @Override
    @NotNull
    public ContextualStoreImpl openStore(@NotNull String name, @NotNull StoreConfig config, @NotNull Transaction transaction) {
        return (ContextualStoreImpl)super.openStore(name, config, transaction);
    }

    @Override
    @Nullable
    public ContextualStoreImpl openStore(@NotNull String name, @NotNull StoreConfig config, @NotNull Transaction transaction, boolean creationRequired) {
        return (ContextualStoreImpl)super.openStore(name, config, transaction, creationRequired);
    }

    @Override
    protected StoreImpl createStore(@NotNull String name, @NotNull TreeMetaInfo metaInfo) {
        return new ContextualStoreImpl(this, name, metaInfo);
    }

    @Override
    @NotNull
    protected TransactionBase beginTransaction(Runnable beginHook, boolean exclusive, boolean cloneMeta) {
        TransactionBase result = super.beginTransaction(beginHook, exclusive, cloneMeta);
        this.setCurrentTransaction(result);
        return result;
    }

    @Override
    @NotNull
    public TransactionBase beginReadonlyTransaction(Runnable beginHook) {
        TransactionBase result = super.beginReadonlyTransaction(beginHook);
        this.setCurrentTransaction(result);
        return result;
    }

    @Override
    @NotNull
    public ReadWriteTransaction beginGCTransaction() {
        ReadWriteTransaction result = super.beginGCTransaction();
        this.setCurrentTransaction(result);
        return result;
    }

    @Override
    public void executeInTransaction(@NotNull TransactionalExecutable executable) {
        TransactionBase current = this.getCurrentTransaction();
        if (current != null) {
            executable.execute((Transaction)current);
        } else {
            super.executeInTransaction(executable);
        }
    }

    @Override
    public void executeInExclusiveTransaction(@NotNull TransactionalExecutable executable) {
        TransactionBase current = this.getCurrentTransaction();
        if (current == null) {
            super.executeInExclusiveTransaction(executable);
        } else {
            if (!current.isExclusive()) {
                throw new ExodusException("Current transaction should be exclusive");
            }
            executable.execute((Transaction)current);
        }
    }

    @Override
    public <T> T computeInTransaction(@NotNull TransactionalComputable<T> computable) {
        TransactionBase current = this.getCurrentTransaction();
        return (T)(current != null ? computable.compute((Transaction)current) : super.computeInTransaction(computable));
    }

    @Override
    public <T> T computeInExclusiveTransaction(@NotNull TransactionalComputable<T> computable) {
        TransactionBase current = this.getCurrentTransaction();
        if (current == null) {
            return super.computeInExclusiveTransaction(computable);
        }
        if (!current.isExclusive()) {
            throw new ExodusException("Current transaction should be exclusive");
        }
        return (T)computable.compute((Transaction)current);
    }

    private void setCurrentTransaction(@NotNull TransactionBase result) {
        Thread thread = result.getCreatingThread();
        Deque<TransactionBase> stack = this.threadTxns.get(thread);
        if (stack == null) {
            stack = new ArrayDeque<TransactionBase>(4);
            this.threadTxns.put(thread, stack);
        }
        stack.push(result);
    }

    @Override
    protected void finishTransaction(@NotNull TransactionBase txn) {
        Thread thread = txn.getCreatingThread();
        if (!Thread.currentThread().equals(thread)) {
            throw new ExodusException("Can't finish transaction in a thread different from the one which it was created in");
        }
        this.finishTransactionUnsafe(txn);
    }

    void finishTransactionUnsafe(@NotNull TransactionBase txn) {
        Thread thread = txn.getCreatingThread();
        Deque<TransactionBase> stack = this.threadTxns.get(thread);
        if (stack == null) {
            throw new ExodusException("Transaction was already finished");
        }
        if (txn != stack.peek()) {
            throw new ExodusException("Can't finish transaction: nested transaction is not finished");
        }
        stack.pop();
        if (stack.isEmpty()) {
            this.threadTxns.remove(thread);
        }
        super.finishTransaction(txn);
    }

    @Override
    protected StoreImpl createTemporaryEmptyStore(String name) {
        return new ContextualTemporaryEmptyStore(this, name);
    }
}

