/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.hook;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.registry.hook.EventHookProvider;
import org.apache.nifi.registry.hook.EventType;
import org.apache.nifi.registry.provider.ProviderConfigurationContext;
import org.apache.nifi.registry.provider.ProviderCreationException;

public abstract class WhitelistFilteringEventHookProvider
implements EventHookProvider {
    static final String EVENT_WHITELIST_PREFIX = "Whitelisted Event Type ";
    static final Pattern EVENT_WHITELIST_PATTERN = Pattern.compile("Whitelisted Event Type \\S+");
    protected Set<EventType> whiteListEvents = null;

    @Override
    public void onConfigured(ProviderConfigurationContext configurationContext) throws ProviderCreationException {
        this.whiteListEvents = new HashSet<EventType>();
        for (Map.Entry<String, String> entry : configurationContext.getProperties().entrySet()) {
            Matcher matcher = EVENT_WHITELIST_PATTERN.matcher(entry.getKey());
            if (!matcher.matches() || entry.getValue() == null || entry.getValue().length() <= 0) continue;
            this.whiteListEvents.add(EventType.valueOf(entry.getValue()));
        }
    }

    @Override
    public boolean shouldHandle(EventType eventType) {
        if (this.whiteListEvents != null && this.whiteListEvents.size() > 0) {
            return this.whiteListEvents.contains((Object)eventType);
        }
        return true;
    }
}

