/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MinimumLengthInputStream
extends FilterInputStream {
    private final long minLength;
    private long consumedCount = 0L;

    public MinimumLengthInputStream(InputStream in, long minLength) {
        super(in);
        this.minLength = minLength;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b < 0 && this.consumedCount < this.minLength) {
            throw new EOFException();
        }
        if (b >= 0) {
            ++this.consumedCount;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int num = super.read(b, off, len);
        if (num < 0 && this.consumedCount < this.minLength) {
            throw new EOFException();
        }
        if (num >= 0) {
            this.consumedCount += (long)num;
        }
        return num;
    }

    @Override
    public long skip(long n) throws IOException {
        int b;
        long skipped = super.skip(n);
        if (skipped < 1L && (b = super.read()) >= 0) {
            skipped = 1L;
        }
        if (skipped < 0L && this.consumedCount < this.minLength) {
            throw new EOFException();
        }
        if (skipped >= 0L) {
            this.consumedCount += skipped;
        }
        return skipped;
    }
}

