/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sts.model.AssumedRoleUser;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.StsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssumeRoleWithSamlResponse
extends StsResponse
implements ToCopyableBuilder<Builder, AssumeRoleWithSamlResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::credentials)).setter(AssumeRoleWithSamlResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<AssumedRoleUser> ASSUMED_ROLE_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssumedRoleUser").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::assumedRoleUser)).setter(AssumeRoleWithSamlResponse.setter(Builder::assumedRoleUser)).constructor(AssumedRoleUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumedRoleUser").build()}).build();
    private static final SdkField<Integer> PACKED_POLICY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PackedPolicySize").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::packedPolicySize)).setter(AssumeRoleWithSamlResponse.setter(Builder::packedPolicySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackedPolicySize").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::subject)).setter(AssumeRoleWithSamlResponse.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> SUBJECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubjectType").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::subjectType)).setter(AssumeRoleWithSamlResponse.setter(Builder::subjectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectType").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::issuer)).setter(AssumeRoleWithSamlResponse.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Audience").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::audience)).setter(AssumeRoleWithSamlResponse.setter(Builder::audience)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audience").build()}).build();
    private static final SdkField<String> NAME_QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameQualifier").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::nameQualifier)).setter(AssumeRoleWithSamlResponse.setter(Builder::nameQualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameQualifier").build()}).build();
    private static final SdkField<String> SOURCE_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIdentity").getter(AssumeRoleWithSamlResponse.getter(AssumeRoleWithSamlResponse::sourceIdentity)).setter(AssumeRoleWithSamlResponse.setter(Builder::sourceIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, ASSUMED_ROLE_USER_FIELD, PACKED_POLICY_SIZE_FIELD, SUBJECT_FIELD, SUBJECT_TYPE_FIELD, ISSUER_FIELD, AUDIENCE_FIELD, NAME_QUALIFIER_FIELD, SOURCE_IDENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Credentials", CREDENTIALS_FIELD);
            this.put("AssumedRoleUser", ASSUMED_ROLE_USER_FIELD);
            this.put("PackedPolicySize", PACKED_POLICY_SIZE_FIELD);
            this.put("Subject", SUBJECT_FIELD);
            this.put("SubjectType", SUBJECT_TYPE_FIELD);
            this.put("Issuer", ISSUER_FIELD);
            this.put("Audience", AUDIENCE_FIELD);
            this.put("NameQualifier", NAME_QUALIFIER_FIELD);
            this.put("SourceIdentity", SOURCE_IDENTITY_FIELD);
        }
    });
    private final Credentials credentials;
    private final AssumedRoleUser assumedRoleUser;
    private final Integer packedPolicySize;
    private final String subject;
    private final String subjectType;
    private final String issuer;
    private final String audience;
    private final String nameQualifier;
    private final String sourceIdentity;

    private AssumeRoleWithSamlResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
        this.subject = builder.subject;
        this.subjectType = builder.subjectType;
        this.issuer = builder.issuer;
        this.audience = builder.audience;
        this.nameQualifier = builder.nameQualifier;
        this.sourceIdentity = builder.sourceIdentity;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final AssumedRoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    public final Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public final String subject() {
        return this.subject;
    }

    public final String subjectType() {
        return this.subjectType;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String audience() {
        return this.audience;
    }

    public final String nameQualifier() {
        return this.nameQualifier;
    }

    public final String sourceIdentity() {
        return this.sourceIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumedRoleUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.packedPolicySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectType());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.audience());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithSamlResponse)) {
            return false;
        }
        AssumeRoleWithSamlResponse other = (AssumeRoleWithSamlResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.assumedRoleUser(), other.assumedRoleUser()) && Objects.equals(this.packedPolicySize(), other.packedPolicySize()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.subjectType(), other.subjectType()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.audience(), other.audience()) && Objects.equals(this.nameQualifier(), other.nameQualifier()) && Objects.equals(this.sourceIdentity(), other.sourceIdentity());
    }

    public final String toString() {
        return ToString.builder((String)"AssumeRoleWithSamlResponse").add("Credentials", (Object)this.credentials()).add("AssumedRoleUser", (Object)this.assumedRoleUser()).add("PackedPolicySize", (Object)this.packedPolicySize()).add("Subject", (Object)this.subject()).add("SubjectType", (Object)this.subjectType()).add("Issuer", (Object)this.issuer()).add("Audience", (Object)this.audience()).add("NameQualifier", (Object)this.nameQualifier()).add("SourceIdentity", (Object)this.sourceIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "AssumedRoleUser": {
                return Optional.ofNullable(clazz.cast(this.assumedRoleUser()));
            }
            case "PackedPolicySize": {
                return Optional.ofNullable(clazz.cast(this.packedPolicySize()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "SubjectType": {
                return Optional.ofNullable(clazz.cast(this.subjectType()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "Audience": {
                return Optional.ofNullable(clazz.cast(this.audience()));
            }
            case "NameQualifier": {
                return Optional.ofNullable(clazz.cast(this.nameQualifier()));
            }
            case "SourceIdentity": {
                return Optional.ofNullable(clazz.cast(this.sourceIdentity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssumeRoleWithSamlResponse, T> g) {
        return obj -> g.apply((AssumeRoleWithSamlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StsResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private AssumedRoleUser assumedRoleUser;
        private Integer packedPolicySize;
        private String subject;
        private String subjectType;
        private String issuer;
        private String audience;
        private String nameQualifier;
        private String sourceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithSamlResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.assumedRoleUser(model.assumedRoleUser);
            this.packedPolicySize(model.packedPolicySize);
            this.subject(model.subject);
            this.subjectType(model.subjectType);
            this.issuer(model.issuer);
            this.audience(model.audience);
            this.nameQualifier(model.nameQualifier);
            this.sourceIdentity(model.sourceIdentity);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return this.assumedRoleUser != null ? this.assumedRoleUser.toBuilder() : null;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getSubjectType() {
            return this.subjectType;
        }

        public final void setSubjectType(String subjectType) {
            this.subjectType = subjectType;
        }

        @Override
        public final Builder subjectType(String subjectType) {
            this.subjectType = subjectType;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAudience() {
            return this.audience;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final String getNameQualifier() {
            return this.nameQualifier;
        }

        public final void setNameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
        }

        @Override
        public final Builder nameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
            return this;
        }

        public final String getSourceIdentity() {
            return this.sourceIdentity;
        }

        public final void setSourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
        }

        @Override
        public final Builder sourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
            return this;
        }

        @Override
        public AssumeRoleWithSamlResponse build() {
            return new AssumeRoleWithSamlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssumeRoleWithSamlResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder assumedRoleUser(AssumedRoleUser var1);

        default public Builder assumedRoleUser(Consumer<AssumedRoleUser.Builder> assumedRoleUser) {
            return this.assumedRoleUser((AssumedRoleUser)((AssumedRoleUser.Builder)AssumedRoleUser.builder().applyMutation(assumedRoleUser)).build());
        }

        public Builder packedPolicySize(Integer var1);

        public Builder subject(String var1);

        public Builder subjectType(String var1);

        public Builder issuer(String var1);

        public Builder audience(String var1);

        public Builder nameQualifier(String var1);

        public Builder sourceIdentity(String var1);
    }
}

