/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.nifi.remote.io.CompressionOutputStream;

public class CompressionInputStream
extends InputStream {
    private final InputStream in;
    private final Inflater inflater;
    private byte[] compressedBuffer;
    private byte[] buffer;
    private int bufferIndex;
    private boolean eos = false;
    private boolean allDataRead = false;
    private final byte[] fourByteBuffer = new byte[4];

    public CompressionInputStream(InputStream in) {
        this.in = in;
        this.inflater = new Inflater();
        this.buffer = new byte[0];
        this.compressedBuffer = new byte[0];
        this.bufferIndex = 1;
    }

    private String toHex(byte[] array) {
        StringBuilder sb = new StringBuilder("0x");
        for (byte b : array) {
            String hex = Integer.toHexString(b).toUpperCase();
            if (hex.length() == 1) {
                sb.append("0");
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    protected void readChunkHeader() throws IOException {
        this.fillBuffer(this.fourByteBuffer);
        if (!Arrays.equals(CompressionOutputStream.SYNC_BYTES, this.fourByteBuffer)) {
            throw new IOException("Invalid CompressionInputStream. Expected first 4 bytes to be 'SYNC' but were " + this.toHex(this.fourByteBuffer));
        }
        this.fillBuffer(this.fourByteBuffer);
        this.buffer = new byte[this.toInt(this.fourByteBuffer)];
        this.fillBuffer(this.fourByteBuffer);
        this.compressedBuffer = new byte[this.toInt(this.fourByteBuffer)];
        this.bufferIndex = this.buffer.length;
    }

    private int toInt(byte[] data) {
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    protected void bufferAndDecompress() throws IOException {
        if (this.allDataRead) {
            this.eos = true;
            return;
        }
        this.readChunkHeader();
        this.fillBuffer(this.compressedBuffer);
        this.inflater.setInput(this.compressedBuffer);
        try {
            this.inflater.inflate(this.buffer);
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        this.inflater.reset();
        this.bufferIndex = 0;
        int moreDataByte = this.in.read();
        if (moreDataByte < 1) {
            this.allDataRead = true;
        } else if (moreDataByte > 1) {
            throw new IOException("Expected indicator of whether or not more data was to come (-1, 0, or 1) but got " + moreDataByte);
        }
    }

    private void fillBuffer(byte[] buffer) throws IOException {
        int len;
        int bytesLeft = buffer.length;
        int bytesRead = 0;
        while (bytesLeft > 0 && (len = this.in.read(buffer, bytesRead, bytesLeft)) > 0) {
            bytesLeft -= len;
            bytesRead += len;
        }
        if (bytesRead < buffer.length) {
            throw new EOFException();
        }
    }

    private boolean isBufferEmpty() {
        return this.bufferIndex >= this.buffer.length;
    }

    @Override
    public int read() throws IOException {
        if (this.eos) {
            return -1;
        }
        if (this.isBufferEmpty()) {
            this.bufferAndDecompress();
        }
        if (this.isBufferEmpty()) {
            this.eos = true;
            return -1;
        }
        return this.buffer[this.bufferIndex++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eos) {
            return -1;
        }
        if (this.isBufferEmpty()) {
            this.bufferAndDecompress();
        }
        if (this.isBufferEmpty()) {
            this.eos = true;
            return -1;
        }
        int free = this.buffer.length - this.bufferIndex;
        int bytesToTransfer = Math.min(len, free);
        System.arraycopy(this.buffer, this.bufferIndex, b, off, bytesToTransfer);
        this.bufferIndex += bytesToTransfer;
        return bytesToTransfer;
    }

    @Override
    public void close() throws IOException {
        this.inflater.end();
    }
}

