/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MessageType {
    RAW("RAW"),
    DIGEST("DIGEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MessageType> VALUE_MAP;
    private final String value;

    private MessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageType> knownValues() {
        EnumSet<MessageType> knownValues = EnumSet.allOf(MessageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MessageType.class, MessageType::toString);
    }
}

