/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.Iterator;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.AbstractHashMap;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010'\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0002#$B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u0018H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0018\u0010\u0019\u001a\u00120\u001aR\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0014J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0017\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0000\u00a2\u0006\u0002\b\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006%"}, d2={"Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap;", "Ljetbrains/exodus/core/dataStructures/hash/AbstractHashMap;", "", "capacity", "", "loadFactor", "", "(IF)V", "mask", "table", "", "Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap$Entry;", "[Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap$Entry;", "addBit", "", "key", "allocateTable", "", "length", "containsKey", "get", "(J)Ljava/lang/Long;", "getEntry", "", "", "hashIterator", "Ljetbrains/exodus/core/dataStructures/hash/AbstractHashMap$HashMapIterator;", "init", "put", "value", "(JJ)Ljava/lang/Long;", "rehash", "remove", "removeBit", "removeBit$xodus_utils", "Entry", "HashIterator", "xodus-utils"})
public final class LongLongHashMap
extends AbstractHashMap<Long, Long> {
    private final float loadFactor;
    @NotNull
    private Entry[] table;
    private int capacity;
    private int mask;

    @JvmOverloads
    public LongLongHashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        boolean $i$f$emptyArray = false;
        this.table = new Entry[0];
        this.init(capacity);
    }

    public /* synthetic */ LongLongHashMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        this(n, f);
    }

    @Nullable
    public Long get(long key) {
        Entry entry = this.getEntry(key);
        return entry == null ? null : entry.getValue();
    }

    @Override
    @Nullable
    public Long put(long key, long value) {
        Entry[] table = this.table;
        boolean bl = false;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        for (Entry e = table[index]; e != null; e = e.getHashNext()) {
            if (e.getKey() != key) continue;
            return e.setValue(value);
        }
        Entry newEntry = new Entry(key, value);
        boolean bl2 = false;
        newEntry.setHashNext(table[index]);
        table[index] = newEntry;
        ++this._size;
        if (this._size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return null;
    }

    public boolean containsKey(long key) {
        return this.getEntry(key) != null;
    }

    @Nullable
    public Long remove(long key) {
        Entry[] table = this.table;
        boolean bl = false;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry entry = table[index];
        if (entry == null) {
            return null;
        }
        Entry e = entry;
        Entry last = null;
        while (key != e.getKey()) {
            last = e;
            if (e.getHashNext() != null) continue;
            return null;
        }
        --this._size;
        if (last == null) {
            table[index] = e.getHashNext();
        } else {
            last.setHashNext(e.getHashNext());
        }
        return e.getValue();
    }

    @Override
    @Nullable
    protected Map.Entry<Long, Long> getEntry(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return TypeIntrinsics.asMutableMapEntry((Object)this.getEntry((Long)key));
    }

    @Override
    protected void init(int capacity) {
        int c = Integer.max(capacity, 4);
        boolean bl = false;
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)c / this.loadFactor)));
        this.capacity = c;
        this._size = 0;
    }

    @Override
    @NotNull
    protected AbstractHashMap.HashMapIterator hashIterator() {
        return new HashIterator();
    }

    public final boolean addBit(long key, long mask) {
        Entry[] table = this.table;
        boolean bl = false;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        for (Entry e = table[index]; e != null; e = e.getHashNext()) {
            boolean result;
            if (e.getKey() != key) continue;
            long value = e.getValue();
            boolean bl2 = result = (value & mask) == 0L;
            if (result) {
                e.setValue(value ^ mask);
            }
            return result;
        }
        Entry newEntry = new Entry(key, mask);
        boolean bl3 = false;
        newEntry.setHashNext(table[index]);
        table[index] = newEntry;
        ++this._size;
        if (this._size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return true;
    }

    public final boolean removeBit$xodus_utils(long key, long mask) {
        Entry[] table = this.table;
        boolean bl = false;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry entry = table[index];
        if (entry == null) {
            return false;
        }
        Entry e = entry;
        Entry last = null;
        while (key != e.getKey()) {
            last = e;
            if (e.getHashNext() != null) continue;
            return false;
        }
        long value = e.getValue();
        if ((value & mask) == 0L) {
            return false;
        }
        e.setValue(value ^ mask);
        if (e.getValue() == 0L) {
            --this._size;
            if (last == null) {
                table[index] = e.getHashNext();
            } else {
                last.setHashNext(e.getHashNext());
            }
        }
        return true;
    }

    private final Entry getEntry(long key) {
        Entry[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        for (Entry e = table[index]; e != null; e = e.getHashNext()) {
            if (e.getKey() != key) continue;
            return e;
        }
        return null;
    }

    private final void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private final void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            Iterator<Map.Entry<Long, Long>> entries = this.entrySet().iterator();
            this.allocateTable(length);
            Entry[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                int index = HashUtil.indexFor(e.getKey(), length, mask);
                e.setHashNext(table[index]);
                table[index] = e;
            }
        }
    }

    @JvmOverloads
    public LongLongHashMap(int capacity) {
        this(capacity, 0.0f, 2, null);
    }

    @JvmOverloads
    public LongLongHashMap() {
        this(0, 0.0f, 3, null);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\t\n\u0002\b\u0010\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\f\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap$Entry;", "", "", "key", "value", "(JJ)V", "hashNext", "getHashNext", "()Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap$Entry;", "setHashNext", "(Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap$Entry;)V", "getKey", "()Ljava/lang/Long;", "getValue", "setValue", "(J)V", "newValue", "(J)Ljava/lang/Long;", "xodus-utils"})
    private static final class Entry
    implements Map.Entry<Long, Long>,
    KMutableMap.Entry {
        private final long key;
        private long value;
        @Nullable
        private Entry hashNext;

        public Entry(long key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @NotNull
        public Long getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Long getValue() {
            return this.value;
        }

        @Override
        public void setValue(long l) {
            this.value = l;
        }

        @Nullable
        public final Entry getHashNext() {
            return this.hashNext;
        }

        public final void setHashNext(@Nullable Entry entry) {
            this.hashNext = entry;
        }

        @Override
        @NotNull
        public Long setValue(long newValue) {
            Long l = this.getValue();
            long it = ((Number)l).longValue();
            boolean bl = false;
            this.setValue(newValue);
            return l;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0014J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap$HashIterator;", "Ljetbrains/exodus/core/dataStructures/hash/AbstractHashMap$HashMapIterator;", "Ljetbrains/exodus/core/dataStructures/hash/AbstractHashMap;", "", "(Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap;)V", "e", "Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap$Entry;", "index", "", "last", "table", "", "[Ljetbrains/exodus/core/dataStructures/hash/LongLongHashMap$Entry;", "hasNext", "", "initNextEntry", "", "nextEntry", "remove", "xodus-utils"})
    private final class HashIterator
    extends AbstractHashMap.HashMapIterator {
        @NotNull
        private final Entry[] table;
        private int index;
        @Nullable
        private Entry e;
        @Nullable
        private Entry last;

        public HashIterator() {
            Intrinsics.checkNotNullParameter((Object)LongLongHashMap.this, (String)"this$0");
            this.table = LongLongHashMap.this.table;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            Entry entry = this.last;
            if (entry == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            LongLongHashMap.this.remove(entry.getKey());
            this.last = null;
        }

        @NotNull
        protected Entry nextEntry() {
            Entry entry;
            Entry entry2 = this.e;
            if (entry2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Entry it = entry = entry2;
            boolean bl = false;
            this.last = it;
            this.initNextEntry();
            return entry;
        }

        private final void initNextEntry() {
            Entry result = this.e;
            if (result != null) {
                result = result.getHashNext();
            }
            Entry[] table = this.table;
            while (result == null && this.index < table.length) {
                int n = this.index;
                this.index = n + 1;
                result = table[n];
            }
            this.e = result;
        }
    }
}

