/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.encryptconfig;

import groovy.cli.commons.CliBuilder;
import groovy.cli.commons.OptionAccessor;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.ConfigEncryptionTool;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.StandardSensitivePropertyProviderFactory;
import org.apache.nifi.properties.scheme.ProtectionScheme;
import org.apache.nifi.properties.scheme.StandardProtectionSchemeResolver;
import org.apache.nifi.registry.properties.util.NiFiRegistryBootstrapUtils;
import org.apache.nifi.toolkit.encryptconfig.Configuration;
import org.apache.nifi.toolkit.encryptconfig.EncryptConfigMain;
import org.apache.nifi.toolkit.encryptconfig.ToolMode;
import org.apache.nifi.toolkit.encryptconfig.util.BootstrapUtil;
import org.apache.nifi.toolkit.encryptconfig.util.NiFiRegistryAuthorizersXmlEncryptor;
import org.apache.nifi.toolkit.encryptconfig.util.NiFiRegistryIdentityProvidersXmlEncryptor;
import org.apache.nifi.toolkit.encryptconfig.util.NiFiRegistryPropertiesEncryptor;
import org.apache.nifi.toolkit.encryptconfig.util.ToolUtilities;
import org.apache.nifi.util.console.TextDevices;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiRegistryMode
implements ToolMode,
GroovyObject {
    private static final Logger logger;
    private static final StandardProtectionSchemeResolver PROTECTION_SCHEME_RESOLVER;
    private CliBuilder cli;
    private boolean verboseEnabled;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NiFiRegistryMode() {
        boolean bl;
        MetaClass metaClass;
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[0].callStatic(NiFiRegistryMode.class);
            this.cli = (CliBuilder)ScriptBytecodeAdapter.castToType((Object)object, CliBuilder.class);
        } else {
            CliBuilder cliBuilder;
            this.cli = cliBuilder = NiFiRegistryMode.cliBuilder();
        }
        this.verboseEnabled = bl = false;
    }

    public static Supplier<BootstrapProperties> getBootstrapSupplier(String bootstrapConfPath) {
        Reference bootstrapConfPath2 = new Reference((Object)bootstrapConfPath);
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        return new Supplier<BootstrapProperties>(bootstrapConfPath2){
            public /* synthetic */ Reference bootstrapConfPath;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.bootstrapConfPath = reference = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public BootstrapProperties get() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                BootstrapProperties bootstrapProperties = (BootstrapProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(NiFiRegistryBootstrapUtils.class, this.bootstrapConfPath.get()), BootstrapProperties.class);
                try {
                    return bootstrapProperties;
                }
                catch (IOException e) {
                    throw (Throwable)callSiteArray[1].callConstructor(SensitivePropertyProtectionException.class, (Object)"Loading Bootstrap Properties failed", (Object)e);
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "loadBootstrapProperties";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
    }

    @Override
    public void run(String ... args) {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        try {
            Object options = callSiteArray[1].call((Object)this.cli, (Object)args);
            if (!DefaultTypeTransformation.booleanUnbox((Object)options) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(options))) {
                callSiteArray[3].call(EncryptConfigMain.class, (Object)"", callSiteArray[4].callGetProperty(EncryptConfigMain.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGetProperty(options))) {
                boolean bl;
                this.verboseEnabled = bl = true;
            }
            NiFiRegistryConfiguration config = (NiFiRegistryConfiguration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callConstructor(NiFiRegistryConfiguration.class, options), NiFiRegistryConfiguration.class);
            callSiteArray[7].callCurrent((GroovyObject)this, (Object)config);
        }
        catch (Exception e) {
            if (this.verboseEnabled) {
                callSiteArray[8].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[9].call((Object)e)}, new String[]{"Encountered an error: ", ""}));
            }
            callSiteArray[10].call(EncryptConfigMain.class, callSiteArray[11].call((Object)e), callSiteArray[12].callGetProperty(EncryptConfigMain.class));
        }
    }

    public void run(NiFiRegistryConfiguration config) throws Exception {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callGetProperty((Object)config))) {
            callSiteArray[14].call((Object)logger, (Object)"Using encryption key derived from password.");
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callGetProperty((Object)config))) {
            callSiteArray[16].call((Object)logger, (Object)"Using encryption key provided.");
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGetProperty((Object)config))) {
            callSiteArray[18].call((Object)logger, (Object)"Using encryption key from input bootstrap.conf.");
        }
        callSiteArray[19].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[20].callGetProperty((Object)config)}, new String[]{"(src)  bootstrap.conf:           ", ""}));
        callSiteArray[21].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[22].callGetProperty((Object)config)}, new String[]{"(dest) bootstrap.conf:           ", ""}));
        callSiteArray[23].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[24].callGetProperty((Object)config)}, new String[]{"(src)  nifi-registry.properties: ", ""}));
        callSiteArray[25].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[26].callGetProperty((Object)config)}, new String[]{"(dest) nifi-registry.properties: ", ""}));
        callSiteArray[27].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[28].callGetProperty((Object)config)}, new String[]{"(src)  identity-providers.xml:   ", ""}));
        callSiteArray[29].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[30].callGetProperty((Object)config)}, new String[]{"(dest) identity-providers.xml:   ", ""}));
        callSiteArray[31].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[32].callGetProperty((Object)config)}, new String[]{"(src)  authorizers.xml:          ", ""}));
        callSiteArray[33].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[34].callGetProperty((Object)config)}, new String[]{"(dest) authorizers.xml:          ", ""}));
        Properties niFiRegistryProperties = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].callGetProperty((Object)config))) {
            try {
                callSiteArray[36].call((Object)logger, (Object)"Encrypting NiFi Registry Properties");
                Object object = callSiteArray[37].call(callSiteArray[38].callGetProperty((Object)config), callSiteArray[39].callGetProperty((Object)config));
                niFiRegistryProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)object, Properties.class);
                Object object2 = callSiteArray[40].call(callSiteArray[41].callGetProperty((Object)config), (Object)niFiRegistryProperties);
                niFiRegistryProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)object2, Properties.class);
                Object object3 = callSiteArray[42].call(callSiteArray[43].callGetProperty((Object)config), (Object)niFiRegistryProperties);
                niFiRegistryProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)object3, Properties.class);
            }
            catch (Exception e) {
                throw (Throwable)callSiteArray[44].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[45].callGetProperty((Object)config), callSiteArray[46].call((Object)e)}, new String[]{"Encountered error trying to load and encrypt NiFi Registry Properties in ", ": ", ""}), (Object)e);
            }
        }
        String identityProvidersXml = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callGetProperty((Object)config))) {
            try {
                callSiteArray[48].call((Object)logger, (Object)"Encrypting Identity Providers XML");
                Object object = callSiteArray[49].call(callSiteArray[50].callGetProperty((Object)config), callSiteArray[51].callGetProperty((Object)config));
                identityProvidersXml = ShortTypeHandling.castToString((Object)object);
                Object object4 = callSiteArray[52].call(callSiteArray[53].callGetProperty((Object)config), (Object)identityProvidersXml);
                identityProvidersXml = ShortTypeHandling.castToString((Object)object4);
                Object object5 = callSiteArray[54].call(callSiteArray[55].callGetProperty((Object)config), (Object)identityProvidersXml);
                identityProvidersXml = ShortTypeHandling.castToString((Object)object5);
            }
            catch (Exception e) {
                throw (Throwable)callSiteArray[56].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[57].callGetProperty((Object)config), callSiteArray[58].call((Object)e)}, new String[]{"Encountered error trying to load and encrypt Identity Providers XML in ", ": ", ""}), (Object)e);
            }
        }
        String authorizersXml = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callGetProperty((Object)config))) {
            try {
                callSiteArray[60].call((Object)logger, (Object)"Encrypting Authorizers XML");
                Object object = callSiteArray[61].call(callSiteArray[62].callGetProperty((Object)config), callSiteArray[63].callGetProperty((Object)config));
                authorizersXml = ShortTypeHandling.castToString((Object)object);
                Object object6 = callSiteArray[64].call(callSiteArray[65].callGetProperty((Object)config), (Object)authorizersXml);
                authorizersXml = ShortTypeHandling.castToString((Object)object6);
                Object object7 = callSiteArray[66].call(callSiteArray[67].callGetProperty((Object)config), (Object)authorizersXml);
                authorizersXml = ShortTypeHandling.castToString((Object)object7);
            }
            catch (Exception e) {
                throw (Throwable)callSiteArray[68].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[69].callGetProperty((Object)config), callSiteArray[70].call((Object)e)}, new String[]{"Encountered error trying to load and encrypt Authorizers XML in ", ": ", ""}), (Object)e);
            }
        }
        try {
            NiFiRegistryMode niFiRegistryMode = this;
            synchronized (niFiRegistryMode) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].callGetProperty((Object)config))) {
                    callSiteArray[72].call(BootstrapUtil.class, callSiteArray[73].callGetProperty((Object)config), callSiteArray[74].callGetProperty(BootstrapUtil.class), callSiteArray[75].callGetProperty((Object)config), callSiteArray[76].callGetProperty((Object)config));
                    callSiteArray[77].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[78].callGetProperty((Object)config)}, new String[]{"Updated bootstrap config file with root key: ", ""}));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[79].callGetProperty((Object)config))) {
                    callSiteArray[80].call(callSiteArray[81].callGetProperty((Object)config), (Object)niFiRegistryProperties, callSiteArray[82].callGetProperty((Object)config), callSiteArray[83].callGetProperty((Object)config));
                    callSiteArray[84].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[85].callGetProperty((Object)config)}, new String[]{"Updated NiFi Registry Properties file with protected values: ", ""}));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[86].callGetProperty((Object)config))) {
                    callSiteArray[87].call(callSiteArray[88].callGetProperty((Object)config), (Object)identityProvidersXml, callSiteArray[89].callGetProperty((Object)config), callSiteArray[90].callGetProperty((Object)config));
                    callSiteArray[91].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[92].callGetProperty((Object)config)}, new String[]{"Updated Identity Providers XML file with protected values: ", ""}));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[93].callGetProperty((Object)config))) {
                    callSiteArray[94].call(callSiteArray[95].callGetProperty((Object)config), (Object)authorizersXml, callSiteArray[96].callGetProperty((Object)config), callSiteArray[97].callGetProperty((Object)config));
                    callSiteArray[98].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[99].callGetProperty((Object)config)}, new String[]{"Updated Authorizers XML file with protected values: ", ""}));
                }
            }
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[100].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[101].call((Object)e)}, new String[]{"Encountered error while writing the output files: ", ""}), (Object)e);
        }
    }

    public static Options getCliOptions() {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].callGroovyObjectGetProperty(callSiteArray[103].callStatic(NiFiRegistryMode.class)), Options.class);
        }
        return (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].callGroovyObjectGetProperty((Object)NiFiRegistryMode.cliBuilder()), Options.class);
    }

    public static CliBuilder cliBuilder() {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        String usage = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[105].call(NiFiRegistryMode.class)}, new String[]{"", " [options]"}));
        int formatWidth = DefaultTypeTransformation.intUnbox((Object)callSiteArray[106].callGetProperty(EncryptConfigMain.class));
        HelpFormatter formatter = (HelpFormatter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].callConstructor(HelpFormatter.class), HelpFormatter.class);
        callSiteArray[108].call((Object)formatter, (Object)formatWidth);
        callSiteArray[109].call((Object)formatter, null);
        CliBuilder cli = (CliBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].callConstructor(CliBuilder.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"usage", usage, "width", formatWidth, "formatter", formatter})), CliBuilder.class);
        callSiteArray[111].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "help"}), (Object)"Show usage information (this message)");
        callSiteArray[112].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "verbose"}), (Object)"Sets verbose mode (default false)");
        callSiteArray[113].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "password", "args", 1, "argName", "password", "optionalArg", true}), (Object)"Protect the files using a password-derived key. If an argument is not provided to this flag, interactive mode will be triggered to prompt the user to enter the password.");
        callSiteArray[114].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "key", "args", 1, "argName", "keyhex", "optionalArg", true}), (Object)"Protect the files using a raw hexadecimal key. If an argument is not provided to this flag, interactive mode will be triggered to prompt the user to enter the key.");
        callSiteArray[115].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "protectionScheme", "args", 1, "argName", "protectionScheme"}), callSiteArray[116].call(String.class, (Object)"Selects the protection scheme for encrypted properties. Default is AES_GCM. Valid values: %s", callSiteArray[117].callGetProperty((Object)PROTECTION_SCHEME_RESOLVER)));
        callSiteArray[118].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "oldPassword", "args", 1, "argName", "password"}), (Object)"If the input files are already protected using a password-derived key, this specifies the old password so that the files can be unprotected before re-protecting.");
        callSiteArray[119].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "oldKey", "args", 1, "argName", "keyhex"}), (Object)"If the input files are already protected using a key, this specifies the raw hexadecimal key so that the files can be unprotected before re-protecting.");
        callSiteArray[120].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "oldProtectionScheme", "args", 1, "argName", "protectionScheme"}), (Object)"The old protection scheme to use during encryption migration (see --protectionScheme for possible values). Default is AES_GCM.");
        callSiteArray[121].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "bootstrapConf", "args", 1, "argName", "file"}), (Object)"The bootstrap.conf file containing no root key or an existing root key, and any other protection scheme configuration properties. If a new password or key is specified (using -p or -k) and no output bootstrap.conf file is specified, then this file will be overwritten to persist the new master key.");
        callSiteArray[122].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "outputBootstrapConf", "args", 1, "argName", "file"}), (Object)"The destination bootstrap.conf file to persist root key. If specified, the input bootstrap.conf will not be modified.");
        callSiteArray[123].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "nifiRegistryProperties", "args", 1, "argName", "file"}), (Object)"The nifi-registry.properties file containing unprotected config values, overwritten if no output file specified.");
        callSiteArray[124].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "outputNifiRegistryProperties", "args", 1, "argName", "file"}), (Object)"The destination nifi-registry.properties file containing protected config values.");
        callSiteArray[125].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "authorizersXml", "args", 1, "argName", "file"}), (Object)"The authorizers.xml file containing unprotected config values, overwritten if no output file specified.");
        callSiteArray[126].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "outputAuthorizersXml", "args", 1, "argName", "file"}), (Object)"The destination authorizers.xml file containing protected config values.");
        callSiteArray[127].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "identityProvidersXml", "args", 1, "argName", "file"}), (Object)"The identity-providers.xml file containing unprotected config values, overwritten if no output file specified.");
        callSiteArray[128].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "outputIdentityProvidersXml", "args", 1, "argName", "file"}), (Object)"The destination identity-providers.xml file containing protected config values.");
        return cli;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NiFiRegistryMode.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, NiFiRegistryMode.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(NiFiRegistryMode.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NiFiRegistryMode.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = NiFiRegistryMode.$getCallSiteArray()[129].call(LoggerFactory.class, NiFiRegistryMode.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = NiFiRegistryMode.$getCallSiteArray()[130].callConstructor(StandardProtectionSchemeResolver.class);
        PROTECTION_SCHEME_RESOLVER = (StandardProtectionSchemeResolver)ScriptBytecodeAdapter.castToType((Object)object2, StandardProtectionSchemeResolver.class);
    }

    @Generated
    public CliBuilder getCli() {
        return this.cli;
    }

    @Generated
    public void setCli(CliBuilder cliBuilder) {
        this.cli = cliBuilder;
    }

    @Generated
    public boolean getVerboseEnabled() {
        return this.verboseEnabled;
    }

    @Generated
    public boolean isVerboseEnabled() {
        return this.verboseEnabled;
    }

    @Generated
    public void setVerboseEnabled(boolean bl) {
        this.verboseEnabled = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "cliBuilder";
        stringArray[1] = "parse";
        stringArray[2] = "h";
        stringArray[3] = "printUsageAndExit";
        stringArray[4] = "EXIT_STATUS_OTHER";
        stringArray[5] = "v";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "run";
        stringArray[8] = "error";
        stringArray[9] = "getMessage";
        stringArray[10] = "printUsageAndExit";
        stringArray[11] = "getMessage";
        stringArray[12] = "EXIT_STATUS_FAILURE";
        stringArray[13] = "usingPassword";
        stringArray[14] = "info";
        stringArray[15] = "usingRawKeyHex";
        stringArray[16] = "info";
        stringArray[17] = "usingBootstrapKey";
        stringArray[18] = "info";
        stringArray[19] = "debug";
        stringArray[20] = "inputBootstrapPath";
        stringArray[21] = "debug";
        stringArray[22] = "outputBootstrapPath";
        stringArray[23] = "debug";
        stringArray[24] = "inputNiFiRegistryPropertiesPath";
        stringArray[25] = "debug";
        stringArray[26] = "outputNiFiRegistryPropertiesPath";
        stringArray[27] = "debug";
        stringArray[28] = "inputIdentityProvidersPath";
        stringArray[29] = "debug";
        stringArray[30] = "outputIdentityProvidersPath";
        stringArray[31] = "debug";
        stringArray[32] = "inputAuthorizersPath";
        stringArray[33] = "debug";
        stringArray[34] = "outputAuthorizersPath";
        stringArray[35] = "handlingNiFiRegistryProperties";
        stringArray[36] = "debug";
        stringArray[37] = "loadFile";
        stringArray[38] = "propertiesEncryptor";
        stringArray[39] = "inputNiFiRegistryPropertiesPath";
        stringArray[40] = "decrypt";
        stringArray[41] = "propertiesEncryptor";
        stringArray[42] = "encrypt";
        stringArray[43] = "propertiesEncryptor";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "inputNiFiRegistryPropertiesPath";
        stringArray[46] = "getMessage";
        stringArray[47] = "handlingIdentityProviders";
        stringArray[48] = "debug";
        stringArray[49] = "loadXmlFile";
        stringArray[50] = "identityProvidersXmlEncryptor";
        stringArray[51] = "inputIdentityProvidersPath";
        stringArray[52] = "decrypt";
        stringArray[53] = "identityProvidersXmlEncryptor";
        stringArray[54] = "encrypt";
        stringArray[55] = "identityProvidersXmlEncryptor";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "inputIdentityProvidersPath";
        stringArray[58] = "getMessage";
        stringArray[59] = "handlingAuthorizers";
        stringArray[60] = "debug";
        stringArray[61] = "loadXmlFile";
        stringArray[62] = "authorizersXmlEncryptor";
        stringArray[63] = "inputAuthorizersPath";
        stringArray[64] = "decrypt";
        stringArray[65] = "authorizersXmlEncryptor";
        stringArray[66] = "encrypt";
        stringArray[67] = "authorizersXmlEncryptor";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "inputAuthorizersPath";
        stringArray[70] = "getMessage";
        stringArray[71] = "writingKeyToBootstrap";
        stringArray[72] = "writeKeyToBootstrapFile";
        stringArray[73] = "encryptionKey";
        stringArray[74] = "REGISTRY_BOOTSTRAP_KEY_PROPERTY";
        stringArray[75] = "outputBootstrapPath";
        stringArray[76] = "inputBootstrapPath";
        stringArray[77] = "info";
        stringArray[78] = "outputBootstrapPath";
        stringArray[79] = "handlingNiFiRegistryProperties";
        stringArray[80] = "write";
        stringArray[81] = "propertiesEncryptor";
        stringArray[82] = "outputNiFiRegistryPropertiesPath";
        stringArray[83] = "inputNiFiRegistryPropertiesPath";
        stringArray[84] = "info";
        stringArray[85] = "outputNiFiRegistryPropertiesPath";
        stringArray[86] = "handlingIdentityProviders";
        stringArray[87] = "writeXmlFile";
        stringArray[88] = "identityProvidersXmlEncryptor";
        stringArray[89] = "outputIdentityProvidersPath";
        stringArray[90] = "inputIdentityProvidersPath";
        stringArray[91] = "info";
        stringArray[92] = "outputIdentityProvidersPath";
        stringArray[93] = "handlingAuthorizers";
        stringArray[94] = "writeXmlFile";
        stringArray[95] = "authorizersXmlEncryptor";
        stringArray[96] = "outputAuthorizersPath";
        stringArray[97] = "inputAuthorizersPath";
        stringArray[98] = "info";
        stringArray[99] = "outputAuthorizersPath";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "getMessage";
        stringArray[102] = "options";
        stringArray[103] = "cliBuilder";
        stringArray[104] = "options";
        stringArray[105] = "getCanonicalName";
        stringArray[106] = "HELP_FORMAT_WIDTH";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "setWidth";
        stringArray[109] = "setOptionComparator";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "h";
        stringArray[112] = "v";
        stringArray[113] = "p";
        stringArray[114] = "k";
        stringArray[115] = "S";
        stringArray[116] = "format";
        stringArray[117] = "supportedProtectionSchemes";
        stringArray[118] = "_";
        stringArray[119] = "_";
        stringArray[120] = "H";
        stringArray[121] = "b";
        stringArray[122] = "B";
        stringArray[123] = "r";
        stringArray[124] = "R";
        stringArray[125] = "a";
        stringArray[126] = "A";
        stringArray[127] = "i";
        stringArray[128] = "I";
        stringArray[129] = "getLogger";
        stringArray[130] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[131];
        NiFiRegistryMode.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(NiFiRegistryMode.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NiFiRegistryMode.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class NiFiRegistryConfiguration
    implements Configuration,
    GroovyObject {
        private OptionAccessor rawOptions;
        private boolean usingRawKeyHex;
        private boolean usingPassword;
        private boolean usingBootstrapKey;
        private ProtectionScheme protectionScheme;
        private String encryptionKey;
        private ProtectionScheme oldProtectionScheme;
        private String decryptionKey;
        private SensitivePropertyProvider encryptionProvider;
        private SensitivePropertyProvider decryptionProvider;
        private SensitivePropertyProviderFactory providerFactory;
        private boolean writingKeyToBootstrap;
        private String inputBootstrapPath;
        private String outputBootstrapPath;
        private boolean handlingNiFiRegistryProperties;
        private String inputNiFiRegistryPropertiesPath;
        private String outputNiFiRegistryPropertiesPath;
        private NiFiRegistryPropertiesEncryptor propertiesEncryptor;
        private boolean handlingIdentityProviders;
        private String inputIdentityProvidersPath;
        private String outputIdentityProvidersPath;
        private NiFiRegistryIdentityProvidersXmlEncryptor identityProvidersXmlEncryptor;
        private boolean handlingAuthorizers;
        private String inputAuthorizersPath;
        private String outputAuthorizersPath;
        private NiFiRegistryAuthorizersXmlEncryptor authorizersXmlEncryptor;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NiFiRegistryConfiguration() {
            MetaClass metaClass;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            this.writingKeyToBootstrap = bl4 = false;
            this.handlingNiFiRegistryProperties = bl3 = false;
            this.handlingIdentityProviders = bl2 = false;
            this.handlingAuthorizers = bl = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public NiFiRegistryConfiguration(OptionAccessor options) {
            boolean bl;
            boolean bl2;
            OptionAccessor optionAccessor;
            MetaClass metaClass;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            this.writingKeyToBootstrap = bl6 = false;
            this.handlingNiFiRegistryProperties = bl5 = false;
            this.handlingIdentityProviders = bl4 = false;
            this.handlingAuthorizers = bl3 = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.rawOptions = optionAccessor = options;
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[0].callCurrent((GroovyObject)this);
            } else {
                this.validateOptions();
            }
            Object object = callSiteArray[1].callGroovyObjectGetProperty((Object)this.rawOptions);
            this.inputBootstrapPath = ShortTypeHandling.castToString((Object)object);
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[2].callCurrent((GroovyObject)this);
            } else {
                this.determineOldProtectionScheme();
            }
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[3].callCurrent((GroovyObject)this);
            } else {
                this.determineDecryptionKey();
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.decryptionKey)) {
                callSiteArray[4].call(ScriptBytecodeAdapter.getField(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)"logger"), (Object)"No decryption key specified via options, so if any input files require decryption prior to re-encryption (i.e., migration), this tool will fail.");
            }
            Object object2 = callSiteArray[5].callGroovyObjectGetProperty((Object)this.rawOptions);
            this.handlingNiFiRegistryProperties = DefaultTypeTransformation.booleanUnbox((Object)object2);
            if (this.handlingNiFiRegistryProperties) {
                Object object3 = callSiteArray[6].callGroovyObjectGetProperty((Object)this.rawOptions);
                this.inputNiFiRegistryPropertiesPath = ShortTypeHandling.castToString((Object)object3);
                Object object4 = callSiteArray[7].callGroovyObjectGetProperty((Object)this.rawOptions);
                Object object5 = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : this.inputNiFiRegistryPropertiesPath;
                this.outputNiFiRegistryPropertiesPath = ShortTypeHandling.castToString((Object)object5);
            }
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[8].callCurrent((GroovyObject)this);
            } else {
                this.determineProtectionScheme();
            }
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[9].callCurrent((GroovyObject)this);
            } else {
                this.determineEncryptionKey();
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.encryptionKey)) {
                throw (Throwable)callSiteArray[10].callConstructor(RuntimeException.class, (Object)"Failed to configure tool, could not determine encryption key. Must provide -p, -k, or -b. If using -b, bootstrap.conf argument must already contain root key.");
            }
            Object object6 = callSiteArray[11].call(StandardSensitivePropertyProviderFactory.class, (Object)this.encryptionKey, callSiteArray[12].callCurrent((GroovyObject)this, (Object)this.inputBootstrapPath));
            this.providerFactory = (SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)object6, SensitivePropertyProviderFactory.class);
            Object object7 = callSiteArray[13].call((Object)this.providerFactory, (Object)this.protectionScheme);
            this.encryptionProvider = (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)object7, SensitivePropertyProvider.class);
            Object object8 = DefaultTypeTransformation.booleanUnbox((Object)this.decryptionKey) ? callSiteArray[14].call((Object)this.providerFactory, (Object)this.oldProtectionScheme) : null;
            this.decryptionProvider = (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType(object8, SensitivePropertyProvider.class);
            if (this.handlingNiFiRegistryProperties) {
                Object object9 = callSiteArray[15].callConstructor(NiFiRegistryPropertiesEncryptor.class, (Object)this.encryptionProvider, (Object)this.decryptionProvider);
                this.propertiesEncryptor = (NiFiRegistryPropertiesEncryptor)ScriptBytecodeAdapter.castToType((Object)object9, NiFiRegistryPropertiesEncryptor.class);
            }
            this.writingKeyToBootstrap = !BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass() ? (bl2 = this.usingPassword || this.usingRawKeyHex || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGroovyObjectGetProperty((Object)this.rawOptions))) : (bl = this.usingPassword || this.usingRawKeyHex || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGroovyObjectGetProperty((Object)this.rawOptions)));
            if (this.writingKeyToBootstrap) {
                Object object10 = callSiteArray[18].callGroovyObjectGetProperty((Object)this.rawOptions);
                Object object11 = DefaultTypeTransformation.booleanUnbox((Object)object10) ? object10 : this.inputBootstrapPath;
                this.outputBootstrapPath = ShortTypeHandling.castToString((Object)object11);
            }
            Object object12 = callSiteArray[19].callGroovyObjectGetProperty((Object)this.rawOptions);
            this.handlingIdentityProviders = DefaultTypeTransformation.booleanUnbox((Object)object12);
            if (this.handlingIdentityProviders) {
                Object object13 = callSiteArray[20].callGroovyObjectGetProperty((Object)this.rawOptions);
                this.inputIdentityProvidersPath = ShortTypeHandling.castToString((Object)object13);
                Object object14 = callSiteArray[21].callGroovyObjectGetProperty((Object)this.rawOptions);
                Object object15 = DefaultTypeTransformation.booleanUnbox((Object)object14) ? object14 : this.inputIdentityProvidersPath;
                this.outputIdentityProvidersPath = ShortTypeHandling.castToString((Object)object15);
                Object object16 = callSiteArray[22].callConstructor(NiFiRegistryIdentityProvidersXmlEncryptor.class, (Object)this.encryptionProvider, (Object)this.decryptionProvider, (Object)this.providerFactory);
                this.identityProvidersXmlEncryptor = (NiFiRegistryIdentityProvidersXmlEncryptor)ScriptBytecodeAdapter.castToType((Object)object16, NiFiRegistryIdentityProvidersXmlEncryptor.class);
            }
            Object object17 = callSiteArray[23].callGroovyObjectGetProperty((Object)this.rawOptions);
            this.handlingAuthorizers = DefaultTypeTransformation.booleanUnbox((Object)object17);
            if (this.handlingAuthorizers) {
                Object object18 = callSiteArray[24].callGroovyObjectGetProperty((Object)this.rawOptions);
                this.inputAuthorizersPath = ShortTypeHandling.castToString((Object)object18);
                Object object19 = callSiteArray[25].callGroovyObjectGetProperty((Object)this.rawOptions);
                Object object20 = DefaultTypeTransformation.booleanUnbox((Object)object19) ? object19 : this.inputAuthorizersPath;
                this.outputAuthorizersPath = ShortTypeHandling.castToString((Object)object20);
                Object object21 = callSiteArray[26].callConstructor(NiFiRegistryAuthorizersXmlEncryptor.class, (Object)this.encryptionProvider, (Object)this.decryptionProvider, (Object)this.providerFactory);
                this.authorizersXmlEncryptor = (NiFiRegistryAuthorizersXmlEncryptor)ScriptBytecodeAdapter.castToType((Object)object21, NiFiRegistryAuthorizersXmlEncryptor.class);
            }
        }

        private void determineProtectionScheme() {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                Object object = callSiteArray[28].call(ScriptBytecodeAdapter.getField(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)"PROTECTION_SCHEME_RESOLVER"), callSiteArray[29].callGroovyObjectGetProperty((Object)this.rawOptions));
                this.protectionScheme = (ProtectionScheme)ScriptBytecodeAdapter.castToType((Object)object, ProtectionScheme.class);
            } else {
                Object object = callSiteArray[30].callGetProperty(ConfigEncryptionTool.class);
                this.protectionScheme = (ProtectionScheme)ScriptBytecodeAdapter.castToType((Object)object, ProtectionScheme.class);
            }
        }

        private void determineOldProtectionScheme() {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                Object object = callSiteArray[32].call(ScriptBytecodeAdapter.getField(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)"PROTECTION_SCHEME_RESOLVER"), callSiteArray[33].callGroovyObjectGetProperty((Object)this.rawOptions));
                this.oldProtectionScheme = (ProtectionScheme)ScriptBytecodeAdapter.castToType((Object)object, ProtectionScheme.class);
            } else {
                Object object = callSiteArray[34].callGetProperty(ConfigEncryptionTool.class);
                this.oldProtectionScheme = (ProtectionScheme)ScriptBytecodeAdapter.castToType((Object)object, ProtectionScheme.class);
            }
        }

        private void validateOptions() {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            String validationFailedMessage = null;
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                String string;
                validationFailedMessage = string = "-b flag for bootstrap.conf is required.";
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                    validationFailedMessage = ShortTypeHandling.castToString((Object)callSiteArray[37].call((Object)validationFailedMessage, (Object)" Input bootsrap.conf will be used as template for output bootstrap.conf"));
                } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].callGroovyObjectGetProperty((Object)this.rawOptions)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                    String string2;
                    validationFailedMessage = string2 = " Encryption key will be persisted to bootstrap.conf";
                }
            }
            if (DefaultTypeTransformation.booleanUnbox(validationFailedMessage)) {
                throw (Throwable)callSiteArray[40].callConstructor(RuntimeException.class, callSiteArray[41].call((Object)"Invalid options: ", (Object)validationFailedMessage));
            }
        }

        private void determineEncryptionKey() {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this.rawOptions)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                String password = null;
                String keyHex = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                    boolean bl;
                    callSiteArray[45].call(ScriptBytecodeAdapter.getField(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)"logger"), (Object)"Attempting to generate key from password.");
                    this.usingPassword = bl = true;
                    Object object = callSiteArray[46].call((Object)this.rawOptions, (Object)"p");
                    password = ShortTypeHandling.castToString((Object)object);
                } else {
                    boolean bl;
                    this.usingRawKeyHex = bl = true;
                    Object object = callSiteArray[47].call((Object)this.rawOptions, (Object)"k");
                    keyHex = ShortTypeHandling.castToString((Object)object);
                }
                Object object = callSiteArray[48].call(ToolUtilities.class, callSiteArray[49].call(TextDevices.class), (Object)keyHex, (Object)password, (Object)this.usingPassword);
                this.encryptionKey = ShortTypeHandling.castToString((Object)object);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[50].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                boolean bl;
                callSiteArray[51].call(ScriptBytecodeAdapter.getField(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)"logger"), (Object)"Attempting to read root key from input bootstrap.conf file.");
                this.usingBootstrapKey = bl = true;
                Object object = callSiteArray[52].call(BootstrapUtil.class, (Object)this.inputBootstrapPath, callSiteArray[53].callGetProperty(BootstrapUtil.class));
                this.encryptionKey = ShortTypeHandling.castToString((Object)object);
                if (!DefaultTypeTransformation.booleanUnbox((Object)this.encryptionKey)) {
                    callSiteArray[54].call(ScriptBytecodeAdapter.getField(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)"logger"), (Object)"-b specified without -p or -k, but the input bootstrap.conf file did not contain a root key.");
                }
            }
        }

        private String determineDecryptionKey() {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                callSiteArray[56].call(ScriptBytecodeAdapter.getField(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)"logger"), (Object)"Attempting to generate decryption key (for migration) from old password.");
                Object object = callSiteArray[57].call(ToolUtilities.class, callSiteArray[58].call(TextDevices.class), null, callSiteArray[59].callGroovyObjectGetProperty((Object)this.rawOptions), (Object)true);
                this.decryptionKey = ShortTypeHandling.castToString((Object)object);
                return ShortTypeHandling.castToString((Object)object);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                Object object = callSiteArray[61].callGroovyObjectGetProperty((Object)this.rawOptions);
                this.decryptionKey = ShortTypeHandling.castToString((Object)object);
                return ShortTypeHandling.castToString((Object)object);
            }
            return ShortTypeHandling.castToString(null);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NiFiRegistryConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public OptionAccessor getRawOptions() {
            return this.rawOptions;
        }

        @Generated
        public void setRawOptions(OptionAccessor optionAccessor) {
            this.rawOptions = optionAccessor;
        }

        @Generated
        public boolean getUsingRawKeyHex() {
            return this.usingRawKeyHex;
        }

        @Generated
        public boolean isUsingRawKeyHex() {
            return this.usingRawKeyHex;
        }

        @Generated
        public void setUsingRawKeyHex(boolean bl) {
            this.usingRawKeyHex = bl;
        }

        @Generated
        public boolean getUsingPassword() {
            return this.usingPassword;
        }

        @Generated
        public boolean isUsingPassword() {
            return this.usingPassword;
        }

        @Generated
        public void setUsingPassword(boolean bl) {
            this.usingPassword = bl;
        }

        @Generated
        public boolean getUsingBootstrapKey() {
            return this.usingBootstrapKey;
        }

        @Generated
        public boolean isUsingBootstrapKey() {
            return this.usingBootstrapKey;
        }

        @Generated
        public void setUsingBootstrapKey(boolean bl) {
            this.usingBootstrapKey = bl;
        }

        @Generated
        public ProtectionScheme getProtectionScheme() {
            return this.protectionScheme;
        }

        @Generated
        public void setProtectionScheme(ProtectionScheme protectionScheme) {
            this.protectionScheme = protectionScheme;
        }

        @Generated
        public String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Generated
        public void setEncryptionKey(String string) {
            this.encryptionKey = string;
        }

        @Generated
        public ProtectionScheme getOldProtectionScheme() {
            return this.oldProtectionScheme;
        }

        @Generated
        public void setOldProtectionScheme(ProtectionScheme protectionScheme) {
            this.oldProtectionScheme = protectionScheme;
        }

        @Generated
        public String getDecryptionKey() {
            return this.decryptionKey;
        }

        @Generated
        public void setDecryptionKey(String string) {
            this.decryptionKey = string;
        }

        @Generated
        public SensitivePropertyProvider getEncryptionProvider() {
            return this.encryptionProvider;
        }

        @Generated
        public void setEncryptionProvider(SensitivePropertyProvider sensitivePropertyProvider) {
            this.encryptionProvider = sensitivePropertyProvider;
        }

        @Generated
        public SensitivePropertyProvider getDecryptionProvider() {
            return this.decryptionProvider;
        }

        @Generated
        public void setDecryptionProvider(SensitivePropertyProvider sensitivePropertyProvider) {
            this.decryptionProvider = sensitivePropertyProvider;
        }

        @Generated
        public SensitivePropertyProviderFactory getProviderFactory() {
            return this.providerFactory;
        }

        @Generated
        public void setProviderFactory(SensitivePropertyProviderFactory sensitivePropertyProviderFactory) {
            this.providerFactory = sensitivePropertyProviderFactory;
        }

        @Generated
        public boolean getWritingKeyToBootstrap() {
            return this.writingKeyToBootstrap;
        }

        @Generated
        public boolean isWritingKeyToBootstrap() {
            return this.writingKeyToBootstrap;
        }

        @Generated
        public void setWritingKeyToBootstrap(boolean bl) {
            this.writingKeyToBootstrap = bl;
        }

        @Generated
        public String getInputBootstrapPath() {
            return this.inputBootstrapPath;
        }

        @Generated
        public void setInputBootstrapPath(String string) {
            this.inputBootstrapPath = string;
        }

        @Generated
        public String getOutputBootstrapPath() {
            return this.outputBootstrapPath;
        }

        @Generated
        public void setOutputBootstrapPath(String string) {
            this.outputBootstrapPath = string;
        }

        @Generated
        public boolean getHandlingNiFiRegistryProperties() {
            return this.handlingNiFiRegistryProperties;
        }

        @Generated
        public boolean isHandlingNiFiRegistryProperties() {
            return this.handlingNiFiRegistryProperties;
        }

        @Generated
        public void setHandlingNiFiRegistryProperties(boolean bl) {
            this.handlingNiFiRegistryProperties = bl;
        }

        @Generated
        public String getInputNiFiRegistryPropertiesPath() {
            return this.inputNiFiRegistryPropertiesPath;
        }

        @Generated
        public void setInputNiFiRegistryPropertiesPath(String string) {
            this.inputNiFiRegistryPropertiesPath = string;
        }

        @Generated
        public String getOutputNiFiRegistryPropertiesPath() {
            return this.outputNiFiRegistryPropertiesPath;
        }

        @Generated
        public void setOutputNiFiRegistryPropertiesPath(String string) {
            this.outputNiFiRegistryPropertiesPath = string;
        }

        @Generated
        public NiFiRegistryPropertiesEncryptor getPropertiesEncryptor() {
            return this.propertiesEncryptor;
        }

        @Generated
        public void setPropertiesEncryptor(NiFiRegistryPropertiesEncryptor niFiRegistryPropertiesEncryptor) {
            this.propertiesEncryptor = niFiRegistryPropertiesEncryptor;
        }

        @Generated
        public boolean getHandlingIdentityProviders() {
            return this.handlingIdentityProviders;
        }

        @Generated
        public boolean isHandlingIdentityProviders() {
            return this.handlingIdentityProviders;
        }

        @Generated
        public void setHandlingIdentityProviders(boolean bl) {
            this.handlingIdentityProviders = bl;
        }

        @Generated
        public String getInputIdentityProvidersPath() {
            return this.inputIdentityProvidersPath;
        }

        @Generated
        public void setInputIdentityProvidersPath(String string) {
            this.inputIdentityProvidersPath = string;
        }

        @Generated
        public String getOutputIdentityProvidersPath() {
            return this.outputIdentityProvidersPath;
        }

        @Generated
        public void setOutputIdentityProvidersPath(String string) {
            this.outputIdentityProvidersPath = string;
        }

        @Generated
        public NiFiRegistryIdentityProvidersXmlEncryptor getIdentityProvidersXmlEncryptor() {
            return this.identityProvidersXmlEncryptor;
        }

        @Generated
        public void setIdentityProvidersXmlEncryptor(NiFiRegistryIdentityProvidersXmlEncryptor niFiRegistryIdentityProvidersXmlEncryptor) {
            this.identityProvidersXmlEncryptor = niFiRegistryIdentityProvidersXmlEncryptor;
        }

        @Generated
        public boolean getHandlingAuthorizers() {
            return this.handlingAuthorizers;
        }

        @Generated
        public boolean isHandlingAuthorizers() {
            return this.handlingAuthorizers;
        }

        @Generated
        public void setHandlingAuthorizers(boolean bl) {
            this.handlingAuthorizers = bl;
        }

        @Generated
        public String getInputAuthorizersPath() {
            return this.inputAuthorizersPath;
        }

        @Generated
        public void setInputAuthorizersPath(String string) {
            this.inputAuthorizersPath = string;
        }

        @Generated
        public String getOutputAuthorizersPath() {
            return this.outputAuthorizersPath;
        }

        @Generated
        public void setOutputAuthorizersPath(String string) {
            this.outputAuthorizersPath = string;
        }

        @Generated
        public NiFiRegistryAuthorizersXmlEncryptor getAuthorizersXmlEncryptor() {
            return this.authorizersXmlEncryptor;
        }

        @Generated
        public void setAuthorizersXmlEncryptor(NiFiRegistryAuthorizersXmlEncryptor niFiRegistryAuthorizersXmlEncryptor) {
            this.authorizersXmlEncryptor = niFiRegistryAuthorizersXmlEncryptor;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "validateOptions";
            stringArray[1] = "b";
            stringArray[2] = "determineOldProtectionScheme";
            stringArray[3] = "determineDecryptionKey";
            stringArray[4] = "debug";
            stringArray[5] = "r";
            stringArray[6] = "r";
            stringArray[7] = "R";
            stringArray[8] = "determineProtectionScheme";
            stringArray[9] = "determineEncryptionKey";
            stringArray[10] = "<$constructor$>";
            stringArray[11] = "withKeyAndBootstrapSupplier";
            stringArray[12] = "getBootstrapSupplier";
            stringArray[13] = "getProvider";
            stringArray[14] = "getProvider";
            stringArray[15] = "<$constructor$>";
            stringArray[16] = "B";
            stringArray[17] = "B";
            stringArray[18] = "B";
            stringArray[19] = "i";
            stringArray[20] = "i";
            stringArray[21] = "I";
            stringArray[22] = "<$constructor$>";
            stringArray[23] = "a";
            stringArray[24] = "a";
            stringArray[25] = "A";
            stringArray[26] = "<$constructor$>";
            stringArray[27] = "S";
            stringArray[28] = "getProtectionScheme";
            stringArray[29] = "S";
            stringArray[30] = "DEFAULT_PROTECTION_SCHEME";
            stringArray[31] = "H";
            stringArray[32] = "getProtectionScheme";
            stringArray[33] = "H";
            stringArray[34] = "DEFAULT_PROTECTION_SCHEME";
            stringArray[35] = "b";
            stringArray[36] = "B";
            stringArray[37] = "plus";
            stringArray[38] = "p";
            stringArray[39] = "k";
            stringArray[40] = "<$constructor$>";
            stringArray[41] = "plus";
            stringArray[42] = "p";
            stringArray[43] = "k";
            stringArray[44] = "p";
            stringArray[45] = "debug";
            stringArray[46] = "getOptionValue";
            stringArray[47] = "getOptionValue";
            stringArray[48] = "determineKey";
            stringArray[49] = "defaultTextDevice";
            stringArray[50] = "b";
            stringArray[51] = "debug";
            stringArray[52] = "extractKeyFromBootstrapFile";
            stringArray[53] = "REGISTRY_BOOTSTRAP_KEY_PROPERTY";
            stringArray[54] = "warn";
            stringArray[55] = "oldPassword";
            stringArray[56] = "debug";
            stringArray[57] = "determineKey";
            stringArray[58] = "defaultTextDevice";
            stringArray[59] = "oldPassword";
            stringArray[60] = "oldKey";
            stringArray[61] = "oldKey";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[62];
            NiFiRegistryConfiguration.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(NiFiRegistryConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NiFiRegistryConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

