/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.web.security.oidc.client.web.OidcAuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.TrackedAuthorizedClientRepository;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationRequest;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponse;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponseClient;
import org.apache.nifi.web.security.oidc.revocation.TokenTypeHint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;

public class AuthorizedClientExpirationCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizedClientExpirationCommand.class);
    private final TrackedAuthorizedClientRepository trackedAuthorizedClientRepository;
    private final TokenRevocationResponseClient tokenRevocationResponseClient;

    public AuthorizedClientExpirationCommand(TrackedAuthorizedClientRepository trackedAuthorizedClientRepository, TokenRevocationResponseClient tokenRevocationResponseClient) {
        this.trackedAuthorizedClientRepository = Objects.requireNonNull(trackedAuthorizedClientRepository, "Repository required");
        this.tokenRevocationResponseClient = Objects.requireNonNull(tokenRevocationResponseClient, "Response Client required");
    }

    @Override
    public void run() {
        logger.debug("Delete Expired Authorized Clients started");
        List<OidcAuthorizedClient> deletedAuthorizedClients = this.deleteExpired();
        for (OidcAuthorizedClient authorizedClient : deletedAuthorizedClients) {
            String identity = authorizedClient.getPrincipalName();
            OAuth2RefreshToken refreshToken = authorizedClient.getRefreshToken();
            if (refreshToken == null) {
                logger.debug("Identity [{}] OIDC Refresh Token not found", (Object)identity);
                continue;
            }
            TokenRevocationRequest revocationRequest = new TokenRevocationRequest(refreshToken.getTokenValue(), TokenTypeHint.REFRESH_TOKEN.getHint());
            TokenRevocationResponse revocationResponse = this.tokenRevocationResponseClient.getRevocationResponse(revocationRequest);
            logger.debug("Identity [{}] OIDC Refresh Token revocation response status [{}]", (Object)identity, (Object)revocationResponse.getStatusCode());
        }
        logger.debug("Delete Expired Authorized Clients completed");
    }

    private List<OidcAuthorizedClient> deleteExpired() {
        try {
            return this.trackedAuthorizedClientRepository.deleteExpired();
        }
        catch (Exception e) {
            logger.warn("Delete Expired Authorized Clients failed", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

