/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Date;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.DateQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.exception.IllegalAttributeException;
import org.apache.nifi.util.FormatUtils;

public class StringToDateEvaluator
extends DateEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> format;
    private final Evaluator<String> timeZone;
    private final DateTimeFormatter preparedFormatter;
    private final boolean preparedFormatterHasRequestedTimeZone;

    public StringToDateEvaluator(Evaluator<String> subject, Evaluator<String> format, Evaluator<String> timeZone) {
        this.subject = subject;
        this.format = format;
        if (format instanceof StringLiteralEvaluator) {
            String evaluatedFormat = format.evaluate(new StandardEvaluationContext(Collections.emptyMap())).getValue();
            DateTimeFormatter dtf = FormatUtils.prepareLenientCaseInsensitiveDateTimeFormatter((String)evaluatedFormat);
            if (timeZone == null) {
                this.preparedFormatter = dtf;
                this.preparedFormatterHasRequestedTimeZone = true;
            } else if (timeZone instanceof StringLiteralEvaluator) {
                this.preparedFormatter = dtf.withZone(ZoneId.of(timeZone.evaluate(new StandardEvaluationContext(Collections.emptyMap())).getValue()));
                this.preparedFormatterHasRequestedTimeZone = true;
            } else {
                this.preparedFormatter = dtf;
                this.preparedFormatterHasRequestedTimeZone = false;
            }
        } else {
            this.preparedFormatter = null;
            this.preparedFormatterHasRequestedTimeZone = false;
        }
        this.timeZone = timeZone;
    }

    @Override
    public QueryResult<Date> evaluate(EvaluationContext evaluationContext) {
        QueryResult<String> tzResult;
        String tz;
        DateTimeFormatter dtf;
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        String formatValue = this.format.evaluate(evaluationContext).getValue();
        if (subjectValue == null || formatValue == null) {
            return new DateQueryResult(null);
        }
        if (this.preparedFormatter != null) {
            dtf = this.preparedFormatter;
        } else {
            QueryResult<String> formatResult = this.format.evaluate(evaluationContext);
            String format = formatResult.getValue();
            if (format == null) {
                return null;
            }
            dtf = FormatUtils.prepareLenientCaseInsensitiveDateTimeFormatter((String)format);
        }
        if (!(this.preparedFormatter != null && this.preparedFormatterHasRequestedTimeZone || this.timeZone == null || (tz = (tzResult = this.timeZone.evaluate(evaluationContext)).getValue()) == null)) {
            dtf = dtf.withZone(ZoneId.of(tz));
        }
        try {
            return new DateQueryResult(Date.from(FormatUtils.parseToInstant((DateTimeFormatter)dtf, (String)subjectValue)));
        }
        catch (DateTimeParseException e) {
            throw new IllegalAttributeException("Cannot parse attribute value as a date; date format: " + formatValue + "; attribute value: " + subjectValue + ". Error: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalAttributeException("Invalid date format: " + formatValue);
        }
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

