/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.encryptor;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.regex.Matcher;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.encryptor.AbstractFlowEncryptor;

public class JsonFlowEncryptor
extends AbstractFlowEncryptor {
    @Override
    public void processFlow(InputStream inputStream, OutputStream outputStream, PropertyEncryptor inputEncryptor, PropertyEncryptor outputEncryptor) {
        JsonFactory factory = new JsonFactory();
        try (JsonGenerator generator = factory.createGenerator(outputStream);
             JsonParser parser = factory.createParser(inputStream);){
            parser.setCodec((ObjectCodec)new ObjectMapper());
            this.processJsonByTokens(parser, generator, inputEncryptor, outputEncryptor);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed Processing Flow Configuration", e);
        }
    }

    private void processJsonByTokens(JsonParser parser, JsonGenerator generator, PropertyEncryptor inputEncryptor, PropertyEncryptor outputEncryptor) throws IOException {
        JsonToken token = parser.nextToken();
        while (token != null) {
            switch (token) {
                case NOT_AVAILABLE: {
                    break;
                }
                case START_OBJECT: {
                    generator.writeStartObject();
                    break;
                }
                case END_OBJECT: {
                    generator.writeEndObject();
                    break;
                }
                case START_ARRAY: {
                    generator.writeStartArray();
                    break;
                }
                case END_ARRAY: {
                    generator.writeEndArray();
                    break;
                }
                case FIELD_NAME: {
                    generator.writeFieldName(parser.getValueAsString());
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    generator.writeEmbeddedObject(parser.getEmbeddedObject());
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getValueAsString();
                    Matcher matcher = ENCRYPTED_PATTERN.matcher(value);
                    if (matcher.matches()) {
                        generator.writeString(this.getOutputEncrypted(matcher.group(1), inputEncryptor, outputEncryptor));
                        break;
                    }
                    generator.writeString(value);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    generator.writeNumber(parser.getIntValue());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    generator.writeRawValue(parser.getValueAsString());
                    break;
                }
                case VALUE_TRUE: {
                    generator.writeBoolean(true);
                    break;
                }
                case VALUE_FALSE: {
                    generator.writeBoolean(false);
                    break;
                }
                case VALUE_NULL: {
                    generator.writeNull();
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Token unrecognized [%s]", token));
                }
            }
            token = parser.nextToken();
        }
    }
}

