/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import java.util.function.Function;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.reactivestreams.Publisher;
import org.springframework.aop.Pointcut;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationInterceptorsOrder;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.PostAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.ReactiveAuthenticationUtils;
import org.springframework.security.authorization.method.ReactiveMethodInvocationUtils;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;

public final class AuthorizationManagerAfterReactiveMethodInterceptor
implements AuthorizationAdvisor {
    private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private static final int RETURN_TYPE_METHOD_PARAMETER_INDEX = -1;
    private final Pointcut pointcut;
    private final ReactiveAuthorizationManager<MethodInvocationResult> authorizationManager;
    private int order = AuthorizationInterceptorsOrder.LAST.getOrder();
    private final MethodAuthorizationDeniedHandler defaultHandler = new ThrowingMethodAuthorizationDeniedHandler();

    public static AuthorizationManagerAfterReactiveMethodInterceptor postAuthorize() {
        return AuthorizationManagerAfterReactiveMethodInterceptor.postAuthorize(new PostAuthorizeReactiveAuthorizationManager());
    }

    public static AuthorizationManagerAfterReactiveMethodInterceptor postAuthorize(ReactiveAuthorizationManager<MethodInvocationResult> authorizationManager) {
        AuthorizationManagerAfterReactiveMethodInterceptor interceptor = new AuthorizationManagerAfterReactiveMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PostAuthorize.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.POST_AUTHORIZE.getOrder());
        return interceptor;
    }

    public AuthorizationManagerAfterReactiveMethodInterceptor(Pointcut pointcut, ReactiveAuthorizationManager<MethodInvocationResult> authorizationManager) {
        Assert.notNull((Object)pointcut, (String)"pointcut cannot be null");
        Assert.notNull(authorizationManager, (String)"authorizationManager cannot be null");
        this.pointcut = pointcut;
        this.authorizationManager = authorizationManager;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        Class<?> type = method.getReturnType();
        boolean isSuspendingFunction = KotlinDetector.isSuspendingFunction((Method)method);
        boolean hasFlowReturnType = COROUTINES_FLOW_CLASS_NAME.equals(new MethodParameter(method, -1).getParameterType().getName());
        boolean hasReactiveReturnType = Publisher.class.isAssignableFrom(type) || isSuspendingFunction || hasFlowReturnType;
        Assert.state((boolean)hasReactiveReturnType, () -> "The returnType " + type + " on " + method + " must return an instance of org.reactivestreams.Publisher (for example, a Mono or Flux) or the function must be a Kotlin coroutine in order to support Reactor Context");
        Mono<Authentication> authentication = ReactiveAuthenticationUtils.getAuthentication();
        Function<Signal, Mono> postAuthorize = signal -> {
            if (signal.isOnComplete()) {
                return Mono.empty();
            }
            if (!signal.hasError()) {
                return this.postAuthorize(authentication, mi, signal.get());
            }
            Throwable patt5718$temp = signal.getThrowable();
            if (patt5718$temp instanceof AuthorizationDeniedException) {
                AuthorizationDeniedException denied = (AuthorizationDeniedException)patt5718$temp;
                return this.postProcess((AuthorizationResult)denied, mi);
            }
            return Mono.error((Throwable)signal.getThrowable());
        };
        ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(type);
        if (hasFlowReturnType) {
            if (isSuspendingFunction) {
                Publisher publisher = (Publisher)ReactiveMethodInvocationUtils.proceed(mi);
                return Flux.from((Publisher)publisher).materialize().flatMap(postAuthorize);
            }
            Assert.state((adapter != null ? 1 : 0) != 0, () -> "The returnType " + type + " on " + method + " must have a org.springframework.core.ReactiveAdapter registered");
            Flux response = Flux.defer(() -> adapter.toPublisher(ReactiveMethodInvocationUtils.proceed(mi))).materialize().flatMap(postAuthorize);
            return KotlinDelegate.asFlow(response);
        }
        Publisher publisher = (Publisher)ReactiveMethodInvocationUtils.proceed(mi);
        if (this.isMultiValue(type, adapter)) {
            Flux flux = Flux.from((Publisher)publisher).materialize().flatMap(postAuthorize);
            return adapter != null ? adapter.fromPublisher((Publisher)flux) : flux;
        }
        Mono mono = Mono.from((Publisher)publisher).materialize().flatMap(postAuthorize);
        return adapter != null ? adapter.fromPublisher((Publisher)mono) : mono;
    }

    private boolean isMultiValue(Class<?> returnType, ReactiveAdapter adapter) {
        if (Flux.class.isAssignableFrom(returnType)) {
            return true;
        }
        return adapter != null && adapter.isMultiValue();
    }

    private Mono<Object> postAuthorize(Mono<Authentication> authentication, MethodInvocation mi, Object result) {
        MethodInvocationResult invocationResult = new MethodInvocationResult(mi, result);
        return this.authorizationManager.check(authentication, invocationResult).switchIfEmpty(Mono.just((Object)new AuthorizationDecision(false))).flatMap(decision -> this.postProcess((AuthorizationResult)decision, invocationResult));
    }

    private Mono<Object> postProcess(AuthorizationResult decision, MethodInvocationResult methodInvocationResult) {
        if (decision.isGranted()) {
            return Mono.just((Object)methodInvocationResult.getResult());
        }
        return Mono.fromSupplier(() -> {
            ReactiveAuthorizationManager<MethodInvocationResult> patt7810$temp = this.authorizationManager;
            if (patt7810$temp instanceof MethodAuthorizationDeniedHandler) {
                MethodAuthorizationDeniedHandler handler = (MethodAuthorizationDeniedHandler)((Object)patt7810$temp);
                return handler.handleDeniedInvocationResult(methodInvocationResult, decision);
            }
            return this.defaultHandler.handleDeniedInvocationResult(methodInvocationResult, decision);
        }).flatMap(processedResult -> {
            if (Mono.class.isAssignableFrom(processedResult.getClass())) {
                return (Mono)processedResult;
            }
            return Mono.justOrEmpty((Object)processedResult);
        });
    }

    private Mono<Object> postProcess(AuthorizationResult decision, MethodInvocation methodInvocation) {
        return Mono.fromSupplier(() -> {
            ReactiveAuthorizationManager<MethodInvocationResult> patt8416$temp = this.authorizationManager;
            if (patt8416$temp instanceof MethodAuthorizationDeniedHandler) {
                MethodAuthorizationDeniedHandler handler = (MethodAuthorizationDeniedHandler)((Object)patt8416$temp);
                return handler.handleDeniedInvocation(methodInvocation, decision);
            }
            return this.defaultHandler.handleDeniedInvocation(methodInvocation, decision);
        }).flatMap(processedResult -> {
            if (Mono.class.isAssignableFrom(processedResult.getClass())) {
                return (Mono)processedResult;
            }
            return Mono.justOrEmpty((Object)processedResult);
        });
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return true;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        private static Object asFlow(Publisher<?> publisher) {
            return ReactiveFlowKt.asFlow(publisher);
        }
    }
}

