/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner;

import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.classpath.ClassPathScanner;
import org.flywaydb.core.internal.scanner.cloud.s3.AwsS3Scanner;
import org.flywaydb.core.internal.scanner.filesystem.FileSystemScanner;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.StringUtils;

public class Scanner<I>
implements ResourceProvider,
ClassProvider<I> {
    private static final Log LOG = LogFactory.getLog(Scanner.class);
    private final List<LoadableResource> resources = new ArrayList<LoadableResource>();
    private final List<Class<? extends I>> classes = new ArrayList<Class<? extends I>>();
    private final HashMap<String, LoadableResource> relativeResourceMap = new HashMap();
    private HashMap<String, LoadableResource> absoluteResourceMap = null;

    public Scanner(Class<I> implementedInterface, boolean stream, ResourceNameCache resourceNameCache, LocationScannerCache locationScannerCache, Configuration configuration) {
        Charset encoding = configuration.getEncoding();
        boolean throwOnMissingLocations = configuration.isFailOnMissingLocations();
        ClassLoader classLoader = configuration.getClassLoader();
        FileSystemScanner fileSystemScanner = new FileSystemScanner(stream, configuration);
        FeatureDetector detector = new FeatureDetector(classLoader);
        for (Location location : configuration.getLocations()) {
            if (location.isFileSystem()) {
                this.resources.addAll(fileSystemScanner.scanForResources(location));
                continue;
            }
            if (location.isGCS()) {
                throw new FlywayEditionUpgradeRequiredException(Tier.TEAMS, LicenseGuard.getTier(configuration), "Google Cloud Storage");
            }
            if (location.isAwsS3()) {
                if (detector.isAwsAvailable()) {
                    Collection<LoadableResource> awsResources = new AwsS3Scanner(encoding, throwOnMissingLocations).scanForResources(location);
                    this.resources.addAll(awsResources);
                    continue;
                }
                LOG.error("Can't read location " + location + "; AWS SDK not found");
                continue;
            }
            ClassPathScanner<I> resourceAndClassScanner = new ClassPathScanner<I>(implementedInterface, classLoader, encoding, location, resourceNameCache, locationScannerCache, throwOnMissingLocations, stream);
            this.resources.addAll(resourceAndClassScanner.scanForResources());
            this.classes.addAll(resourceAndClassScanner.scanForClasses());
        }
        for (LoadableResource resource : this.resources) {
            this.relativeResourceMap.put(resource.getRelativePath().toLowerCase(), resource);
        }
    }

    @Override
    public LoadableResource getResource(String name) {
        LoadableResource loadedResource = this.relativeResourceMap.get(name.toLowerCase());
        if (loadedResource != null) {
            return loadedResource;
        }
        if (Paths.get(name, new String[0]).isAbsolute()) {
            if (this.absoluteResourceMap == null) {
                this.absoluteResourceMap = new HashMap();
                for (LoadableResource resource : this.resources) {
                    this.absoluteResourceMap.put(resource.getAbsolutePathOnDisk().toLowerCase(), resource);
                }
            }
            if ((loadedResource = this.absoluteResourceMap.get(name.toLowerCase())) != null) {
                return loadedResource;
            }
        }
        return null;
    }

    @Override
    public Collection<LoadableResource> getResources(String prefix, String ... suffixes) {
        ArrayList<LoadableResource> result = new ArrayList<LoadableResource>();
        for (LoadableResource resource : this.resources) {
            String fileName = resource.getFilename();
            if (StringUtils.startsAndEndsWith(fileName, prefix, suffixes)) {
                result.add(resource);
                continue;
            }
            LOG.debug("Filtering out resource: " + resource.getAbsolutePath() + " (filename: " + fileName + ")");
        }
        return result;
    }

    @Override
    public Collection<Class<? extends I>> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }
}

