/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.AssetEntity;
import org.apache.nifi.web.api.entity.AssetsEntity;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterContextsEntity;

public class JerseyParamContextClient
extends AbstractJerseyClient
implements ParamContextClient {
    private final WebTarget flowTarget;
    private final WebTarget paramContextTarget;

    public JerseyParamContextClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyParamContextClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.flowTarget = baseTarget.path("/flow");
        this.paramContextTarget = baseTarget.path("/parameter-contexts");
    }

    @Override
    public ParameterContextsEntity getParamContexts() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving parameter contexts", () -> {
            WebTarget target = this.flowTarget.path("/parameter-contexts");
            return (ParameterContextsEntity)this.getRequestBuilder(target).get(ParameterContextsEntity.class);
        });
    }

    @Override
    public ParameterContextEntity getParamContext(String id, boolean includeInheritedParameters) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        return this.executeAction("Error retrieving parameter context", () -> {
            WebTarget target = this.paramContextTarget.path("{id}").resolveTemplate("id", (Object)id).queryParam("includeInheritedParameters", new Object[]{String.valueOf(includeInheritedParameters)});
            return (ParameterContextEntity)this.getRequestBuilder(target).get(ParameterContextEntity.class);
        });
    }

    @Override
    public ParameterContextEntity createParamContext(ParameterContextEntity paramContext) throws NiFiClientException, IOException {
        if (paramContext == null) {
            throw new IllegalArgumentException("Parameter context cannot be null or blank");
        }
        return this.executeAction("Error creating parameter context", () -> {
            WebTarget target = this.paramContextTarget;
            return (ParameterContextEntity)this.getRequestBuilder(target).post(Entity.entity((Object)paramContext, (String)"application/json"), ParameterContextEntity.class);
        });
    }

    @Override
    public ParameterContextEntity deleteParamContext(String id, String version) throws NiFiClientException, IOException {
        return this.deleteParamContext(id, version, false);
    }

    @Override
    public ParameterContextEntity deleteParamContext(String id, String version, boolean disconnectedNodeAcknowledged) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        return this.executeAction("Error deleting parameter context", () -> {
            WebTarget target = this.paramContextTarget.path("{id}").resolveTemplate("id", (Object)id).queryParam("version", new Object[]{version});
            if (disconnectedNodeAcknowledged) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (ParameterContextEntity)this.getRequestBuilder(target).delete(ParameterContextEntity.class);
        });
    }

    @Override
    public ParameterContextUpdateRequestEntity updateParamContext(ParameterContextEntity paramContext) throws NiFiClientException, IOException {
        if (paramContext == null) {
            throw new IllegalArgumentException("Parameter context entity cannot be null");
        }
        if (paramContext.getComponent() == null) {
            throw new IllegalArgumentException("Parameter context DTO cannot be null");
        }
        String paramContextId = paramContext.getComponent().getId();
        if (StringUtils.isBlank((CharSequence)paramContextId)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        return this.executeAction("Error creating parameter context update request", () -> {
            WebTarget target = this.paramContextTarget.path("{id}/update-requests").resolveTemplate("id", (Object)paramContextId);
            return (ParameterContextUpdateRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)paramContext, (String)"application/json"), ParameterContextUpdateRequestEntity.class);
        });
    }

    @Override
    public ParameterContextUpdateRequestEntity getParamContextUpdateRequest(String contextId, String updateRequestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)updateRequestId)) {
            throw new IllegalArgumentException("Parameter context update request id cannot be null or blank");
        }
        return this.executeAction("Error retrieving parameter context", () -> {
            WebTarget target = this.paramContextTarget.path("{context-id}/update-requests/{request-id}").resolveTemplate("context-id", (Object)contextId).resolveTemplate("request-id", (Object)updateRequestId);
            return (ParameterContextUpdateRequestEntity)this.getRequestBuilder(target).get(ParameterContextUpdateRequestEntity.class);
        });
    }

    @Override
    public ParameterContextUpdateRequestEntity deleteParamContextUpdateRequest(String contextId, String updateRequestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)updateRequestId)) {
            throw new IllegalArgumentException("Parameter context update request id cannot be null or blank");
        }
        return this.executeAction("Error deleting parameter context update request", () -> {
            WebTarget target = this.paramContextTarget.path("{context-id}/update-requests/{request-id}").resolveTemplate("context-id", (Object)contextId).resolveTemplate("request-id", (Object)updateRequestId);
            return (ParameterContextUpdateRequestEntity)this.getRequestBuilder(target).delete(ParameterContextUpdateRequestEntity.class);
        });
    }

    @Override
    public AssetEntity createAsset(String contextId, String assetName, File file) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)contextId)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)assetName)) {
            throw new IllegalArgumentException("Asset name cannot be null or blank");
        }
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        try (FileInputStream assetInputStream = new FileInputStream(file);){
            AssetEntity assetEntity = this.executeAction("Error Creating Asset " + assetName + " for Parameter Context " + contextId, () -> {
                WebTarget target = this.paramContextTarget.path("{context-id}/assets").resolveTemplate("context-id", (Object)contextId);
                return (AssetEntity)this.getRequestBuilder(target).header("Filename", (Object)assetName).post(Entity.entity((Object)assetInputStream, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE), AssetEntity.class);
            });
            return assetEntity;
        }
    }

    @Override
    public AssetsEntity getAssets(String contextId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)contextId)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        return this.executeAction("Error retrieving parameter context assets", () -> {
            WebTarget target = this.paramContextTarget.path("{context-id}/assets").resolveTemplate("context-id", (Object)contextId);
            return (AssetsEntity)this.getRequestBuilder(target).get(AssetsEntity.class);
        });
    }

    @Override
    public Path getAssetContent(String contextId, String assetId, File outputDirectory) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)contextId)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)assetId)) {
            throw new IllegalArgumentException("Asset id cannot be null or blank");
        }
        return this.executeAction("Error getting asset content", () -> {
            WebTarget target = this.paramContextTarget.path("{context-id}/assets/{asset-id}").resolveTemplate("context-id", (Object)contextId).resolveTemplate("asset-id", (Object)assetId);
            Response response = this.getRequestBuilder(target).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get();
            String filename = this.getContentDispositionFilename(response);
            File assetFile = new File(outputDirectory, filename);
            try (InputStream responseInputStream = (InputStream)response.readEntity(InputStream.class);){
                Files.copy(responseInputStream, assetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Path path = assetFile.toPath();
                return path;
            }
        });
    }

    @Override
    public AssetEntity deleteAsset(String contextId, String assetId) throws NiFiClientException, IOException {
        return this.deleteAsset(contextId, assetId, false);
    }

    @Override
    public AssetEntity deleteAsset(String contextId, String assetId, boolean disconnectedNodeAcknowledged) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)contextId)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)assetId)) {
            throw new IllegalArgumentException("Asset id cannot be null or blank");
        }
        return this.executeAction("Error deleting asset", () -> {
            WebTarget target = this.paramContextTarget.path("{context-id}/assets/{asset-id}").resolveTemplate("context-id", (Object)contextId).resolveTemplate("asset-id", (Object)assetId);
            if (disconnectedNodeAcknowledged) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (AssetEntity)this.getRequestBuilder(target).delete(AssetEntity.class);
        });
    }
}

