/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.FlowAnalysisRuleResult;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;

public class GetFlowAnalysisRule
extends AbstractNiFiCommand<FlowAnalysisRuleResult> {
    public GetFlowAnalysisRule() {
        super("get-flow-analysis-rule", FlowAnalysisRuleResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves a flow analysis rule.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.FAR_ID.createOption());
    }

    @Override
    public FlowAnalysisRuleResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String ruleId = this.getRequiredArg(properties, CommandOption.FAR_ID);
        ControllerClient controllerClient = client.getControllerClient();
        FlowAnalysisRuleEntity ruleEntity = controllerClient.getFlowAnalysisRule(ruleId);
        return new FlowAnalysisRuleResult(this.getResultType(properties), ruleEntity);
    }
}

