/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;

public abstract class AbstractUpdateParamContextCommand<R extends Result>
extends AbstractNiFiCommand<R> {
    private static final int MAX_TIMEOUT_SECONDS = 600;
    private static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private static final long POLL_INTERVAL_MILLIS = 2000L;

    public AbstractUpdateParamContextCommand(String name, Class<R> resultClass) {
        super(name, resultClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParameterContextUpdateRequestEntity performUpdate(ParamContextClient client, ParameterContextEntity parameterContextEntity, ParameterContextUpdateRequestEntity updateRequestEntity, int updateTimeoutSeconds) throws NiFiClientException, IOException {
        int maxPollIterations = Math.min(Math.max(Long.valueOf((long)updateTimeoutSeconds * 1000L / 2000L).intValue(), 1), 600);
        AtomicBoolean cancelled = new AtomicBoolean(false);
        String contextId = parameterContextEntity.getId();
        String updateRequestId = updateRequestEntity.getRequest().getRequestId();
        try {
            boolean completed = false;
            for (int i = 0; i < maxPollIterations; ++i) {
                ParameterContextUpdateRequestEntity retrievedUpdateRequest = client.getParamContextUpdateRequest(contextId, updateRequestId);
                if (retrievedUpdateRequest != null && retrievedUpdateRequest.getRequest().isComplete()) {
                    completed = true;
                    break;
                }
                try {
                    if (this.getContext().isInteractive()) {
                        this.println("Waiting for update request to complete...");
                    }
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!completed) {
                cancelled.set(true);
            }
        }
        finally {
            ParameterContextUpdateRequestEntity deleteUpdateRequest = client.deleteParamContextUpdateRequest(contextId, updateRequestId);
            String failureReason = deleteUpdateRequest.getRequest().getFailureReason();
            if (!StringUtils.isBlank((CharSequence)failureReason)) {
                throw new NiFiClientException(failureReason);
            }
            if (cancelled.get()) {
                throw new NiFiClientException("Unable to update parameter context in time, cancelling update request");
            }
            return deleteUpdateRequest;
        }
    }

    protected int getUpdateTimeout(Properties properties) {
        try {
            Integer updateTimeoutSeconds = this.getIntArg(properties, CommandOption.UPDATE_TIMEOUT);
            return updateTimeoutSeconds == null ? 60 : updateTimeoutSeconds;
        }
        catch (MissingOptionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected ParameterContextEntity createContextEntityForUpdate(String paramContextId, ParameterDTO parameterDTO, List<ParameterContextReferenceEntity> inheritedParameterContexts, RevisionDTO paramContextRevision) {
        ParameterEntity parameterEntity = new ParameterEntity();
        parameterEntity.setParameter(parameterDTO);
        ParameterContextDTO parameterContextDTO = new ParameterContextDTO();
        parameterContextDTO.setId(paramContextId);
        parameterContextDTO.setParameters(Collections.singleton(parameterEntity));
        parameterContextDTO.setInheritedParameterContexts(inheritedParameterContexts);
        ParameterContextEntity updatedParameterContextEntity = new ParameterContextEntity();
        updatedParameterContextEntity.setId(paramContextId);
        updatedParameterContextEntity.setComponent(parameterContextDTO);
        updatedParameterContextEntity.setRevision(paramContextRevision);
        return updatedParameterContextEntity;
    }
}

