/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ControllerServicesResult;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;

public class PGGetControllerServices
extends AbstractNiFiCommand<ControllerServicesResult> {
    public PGGetControllerServices() {
        super("pg-get-services", ControllerServicesResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves the list of controller services for the given process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public ControllerServicesResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        FlowClient flowClient = client.getFlowClient();
        ControllerServicesEntity servicesEntity = flowClient.getControllerServices(pgId);
        return new ControllerServicesResult(this.getResultType(properties), servicesEntity);
    }
}

