/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ComparisonChain;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.command.registry.bucket.ListBuckets;
import org.apache.nifi.toolkit.cli.impl.command.registry.flow.ListFlowVersions;
import org.apache.nifi.toolkit.cli.impl.command.registry.flow.ListFlows;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;

public class ImportAllFlows
extends AbstractNiFiRegistryCommand<StringResult> {
    private static final String FILE_NAME_PREFIX = "toolkit_registry_export_all_";
    private static final String SKIPPING_BUCKET_CREATION = " already exists, skipping bucket creation...";
    private static final String SKIPPING_IMPORT = " already exists, skipping import...";
    private static final String SKIPPING_FLOW_CREATION = " already exists, skipping flow creation...";
    private static final String IMPORT_COMPLETED = "Import completed...";
    private static final String ALL_BUCKETS_COLLECTED = "All buckets collected...";
    private static final String ALL_FLOWS_COLLECTED = "All flows collected...";
    private static final String ALL_FLOW_VERSIONS_COLLECTED = "All flow versions collected...";
    private static final String FILE_NAME_SEPARATOR = "_";
    private static final String STORAGE_LOCATION_URL = "%s/nifi-registry-api/buckets/%s/flows/%s/versions/%s";
    private static final String VERSION_IMPORTING_STARTED = "Importing %s - %s to %s";
    private static final String VERSION_IMPORTING_FINISHED = "Successfully imported %s - %s to %s";
    private static final ObjectMapper MAPPER = JacksonUtils.getObjectMapper();
    private final ListBuckets listBuckets = new ListBuckets();
    private final ListFlows listFlows = new ListFlows();
    private final ListFlowVersions listFlowVersions = new ListFlowVersions();

    public ImportAllFlows() {
        super("import-all-flows", StringResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
        this.addOption(CommandOption.SKIP_EXISTING.createOption());
        this.listBuckets.initialize(context);
        this.listFlows.initialize(context);
        this.listFlowVersions.initialize(context);
    }

    @Override
    public String getDescription() {
        return "From a provided directory as input, the directory content must be generated by the export-all-flows command, based on the file contents, the corresponding buckets, flows and flow versions will be created.If not configured otherwise, already existing objects will be skipped.";
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException, CommandException {
        boolean skip = this.getArg(properties, CommandOption.SKIP_EXISTING) == null ? Boolean.FALSE : Boolean.TRUE;
        boolean isInteractive = this.getContext().isInteractive();
        Map<String, String> bucketMap = this.getBucketMap(client, isInteractive);
        Map<Pair<String, String>, String> flowMap = this.getFlowMap(client, bucketMap, isInteractive);
        HashMap<Pair<String, String>, String> flowCreated = new HashMap<Pair<String, String>, String>();
        Map<String, List<Integer>> versionMap = this.getVersionMap(client, flowMap, isInteractive);
        List<VersionFileMetaData> files = this.getFilePathList(properties);
        files.sort((o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.getBucketName()), (Comparable)((Object)o2.getBucketName())).compare((Comparable)((Object)o1.getFlowName()), (Comparable)((Object)o2.getFlowName())).compare(o1.getVersion(), o2.getVersion()).result());
        for (VersionFileMetaData file : files) {
            String inputSource = file.getInputSource();
            String fileContent = this.getInputSourceContent(inputSource);
            VersionedFlowSnapshot snapshot = (VersionedFlowSnapshot)MAPPER.readValue(fileContent, VersionedFlowSnapshot.class);
            String bucketName = snapshot.getBucket().getName();
            String bucketDescription = snapshot.getBucket().getDescription();
            String flowName = snapshot.getFlow().getName();
            String flowDescription = snapshot.getFlow().getDescription();
            int flowVersion = snapshot.getSnapshotMetadata().getVersion();
            String flowId = snapshot.getFlow().getIdentifier();
            String bucketId = snapshot.getBucket().getIdentifier();
            this.printMessage(isInteractive, String.format(VERSION_IMPORTING_STARTED, flowName, flowVersion, bucketName));
            if (bucketMap.containsKey(bucketName)) {
                this.printMessage(isInteractive, bucketName + SKIPPING_BUCKET_CREATION);
            } else {
                this.createBucket(client, bucketMap, bucketName, bucketDescription, bucketId);
            }
            if (flowMap.containsKey(new ImmutablePair((Object)bucketId, (Object)flowName))) {
                if (skip) {
                    this.printMessage(isInteractive, flowName + SKIPPING_IMPORT);
                    continue;
                }
                this.printMessage(isInteractive, flowName + SKIPPING_FLOW_CREATION);
            } else if (!flowCreated.containsKey(new ImmutablePair((Object)bucketId, (Object)flowName))) {
                this.createFlow(client, flowCreated, flowId, flowName, flowDescription, bucketId);
            }
            if (!versionMap.getOrDefault(flowId, Collections.emptyList()).contains(flowVersion)) {
                String registryUrl = this.getRequiredArg(properties, CommandOption.URL);
                this.updateStorageLocation(snapshot.getFlowContents(), registryUrl);
                this.createFlowVersion(client, snapshot, bucketId, flowId);
            }
            this.printMessage(isInteractive, String.format(VERSION_IMPORTING_FINISHED, flowName, flowVersion, bucketName));
        }
        return new StringResult(IMPORT_COMPLETED, this.getContext().isInteractive());
    }

    private Map<String, String> getBucketMap(NiFiRegistryClient client, boolean isInteractive) throws IOException, NiFiRegistryException {
        this.printMessage(isInteractive, ALL_BUCKETS_COLLECTED);
        return this.listBuckets.doExecute(client, new Properties()).getResult().stream().collect(Collectors.toMap(Bucket::getName, Bucket::getIdentifier));
    }

    private Map<Pair<String, String>, String> getFlowMap(NiFiRegistryClient client, Map<String, String> bucketMap, boolean isInteractive) throws ParseException, IOException, NiFiRegistryException {
        this.printMessage(isInteractive, ALL_FLOWS_COLLECTED);
        return this.getVersionedFlows(client, bucketMap).stream().collect(Collectors.toMap(e -> new ImmutablePair((Object)e.getBucketIdentifier(), (Object)e.getName()), BucketItem::getIdentifier));
    }

    private List<VersionedFlow> getVersionedFlows(NiFiRegistryClient client, Map<String, String> bucketMap) throws ParseException, IOException, NiFiRegistryException {
        ArrayList<VersionedFlow> flows = new ArrayList<VersionedFlow>();
        for (String id : bucketMap.values()) {
            Properties flowProperties = new Properties();
            flowProperties.setProperty(CommandOption.BUCKET_ID.getLongName(), id);
            flows.addAll((Collection<VersionedFlow>)this.listFlows.doExecute(client, flowProperties).getResult());
        }
        return flows;
    }

    private Map<String, List<Integer>> getVersionMap(NiFiRegistryClient client, Map<Pair<String, String>, String> flowMap, boolean isInteractive) throws ParseException, IOException, NiFiRegistryException {
        this.printMessage(isInteractive, ALL_FLOW_VERSIONS_COLLECTED);
        return this.getVersionedFlowSnapshotMetadataList(client, flowMap).stream().collect(Collectors.groupingBy(VersionedFlowSnapshotMetadata::getFlowIdentifier, Collectors.mapping(VersionedFlowSnapshotMetadata::getVersion, Collectors.toList())));
    }

    private List<VersionedFlowSnapshotMetadata> getVersionedFlowSnapshotMetadataList(NiFiRegistryClient client, Map<Pair<String, String>, String> flowMap) throws ParseException, IOException, NiFiRegistryException {
        ArrayList<VersionedFlowSnapshotMetadata> versions = new ArrayList<VersionedFlowSnapshotMetadata>();
        for (String flowIds : flowMap.values()) {
            Properties flowVersionProperties = new Properties();
            flowVersionProperties.setProperty(CommandOption.FLOW_ID.getLongName(), flowIds);
            versions.addAll((Collection<VersionedFlowSnapshotMetadata>)this.listFlowVersions.doExecute(client, flowVersionProperties).getResult());
        }
        return versions;
    }

    private List<VersionFileMetaData> getFilePathList(Properties properties) throws MissingOptionException, NiFiRegistryException {
        List<VersionFileMetaData> files;
        String directory = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        try (Stream<Path> paths = Files.list(Paths.get(directory, new String[0]));){
            files = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(FILE_NAME_PREFIX)).map(VersionFileMetaData::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new NiFiRegistryException("File listing failed", (Throwable)e);
        }
        return files;
    }

    private void createBucket(NiFiRegistryClient client, Map<String, String> bucketMap, String bucketName, String bucketDescription, String bucketId) throws IOException, NiFiRegistryException {
        BucketClient bucketClient = client.getBucketClient();
        Bucket bucket = new Bucket();
        bucket.setIdentifier(bucketId);
        bucket.setName(bucketName);
        bucket.setDescription(bucketDescription);
        bucketClient.create(bucket, Boolean.TRUE.booleanValue());
        bucketMap.put(bucketName, bucketId);
    }

    private void createFlow(NiFiRegistryClient client, Map<Pair<String, String>, String> flowCreated, String flowId, String flowName, String flowDescription, String bucketId) throws IOException, NiFiRegistryException {
        FlowClient flowClient = client.getFlowClient();
        VersionedFlow flow = new VersionedFlow();
        flow.setIdentifier(flowId);
        flow.setName(flowName);
        flow.setDescription(flowDescription);
        flow.setBucketIdentifier(bucketId);
        flowClient.create(flow);
        flowCreated.put((Pair<String, String>)new ImmutablePair((Object)bucketId, (Object)flowName), flowId);
    }

    private void updateStorageLocation(VersionedProcessGroup group, String registryUrl) {
        VersionedFlowCoordinates flowCoordinates = group.getVersionedFlowCoordinates();
        if (flowCoordinates != null && !flowCoordinates.getStorageLocation().startsWith(registryUrl)) {
            String updatedStorageLocation = String.format(STORAGE_LOCATION_URL, registryUrl, flowCoordinates.getBucketId(), flowCoordinates.getFlowId(), flowCoordinates.getVersion());
            flowCoordinates.setStorageLocation(updatedStorageLocation);
        }
        for (VersionedProcessGroup processGroup : group.getProcessGroups()) {
            this.updateStorageLocation(processGroup, registryUrl);
        }
    }

    private void createFlowVersion(NiFiRegistryClient client, VersionedFlowSnapshot snapshot, String bucketId, String flowId) throws IOException, NiFiRegistryException {
        int version;
        FlowSnapshotClient snapshotClient = client.getFlowSnapshotClient();
        try {
            VersionedFlowSnapshotMetadata latestMetadata = snapshotClient.getLatestMetadata(bucketId, flowId);
            version = latestMetadata.getVersion() + 1;
        }
        catch (NiFiRegistryException e) {
            version = 1;
        }
        snapshot.getSnapshotMetadata().setFlowIdentifier(flowId);
        snapshot.getSnapshotMetadata().setBucketIdentifier(bucketId);
        snapshot.getSnapshotMetadata().setVersion(version);
        snapshotClient.create(snapshot, true);
    }

    private void printMessage(boolean isInteractive, String message) {
        if (isInteractive) {
            this.println();
            this.println(message);
            this.println();
        }
    }

    public static class VersionFileMetaData {
        private final String inputSource;
        private final String bucketName;
        private final String flowName;
        private final int version;

        public VersionFileMetaData(Path path) {
            String[] fileNameElements = path.getFileName().toString().split(ImportAllFlows.FILE_NAME_SEPARATOR);
            this.inputSource = path.toString();
            this.bucketName = fileNameElements[4];
            this.flowName = fileNameElements[5];
            this.version = Integer.parseInt(fileNameElements[6]);
        }

        public String getInputSource() {
            return this.inputSource;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getFlowName() {
            return this.flowName;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

