/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.ott;

import java.util.Collection;
import java.util.Collections;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class OneTimeTokenAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -8691636031126328365L;
    private final Object principal;
    private String tokenValue;

    public OneTimeTokenAuthenticationToken(Object principal, String tokenValue) {
        super(Collections.emptyList());
        this.tokenValue = tokenValue;
        this.principal = principal;
    }

    public OneTimeTokenAuthenticationToken(String tokenValue) {
        this(null, tokenValue);
    }

    public OneTimeTokenAuthenticationToken(Object principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.setAuthenticated(true);
    }

    public static OneTimeTokenAuthenticationToken unauthenticated(String tokenValue) {
        return new OneTimeTokenAuthenticationToken(null, tokenValue);
    }

    public static OneTimeTokenAuthenticationToken unauthenticated(Object principal, String tokenValue) {
        return new OneTimeTokenAuthenticationToken(principal, tokenValue);
    }

    public static OneTimeTokenAuthenticationToken authenticated(Object principal, Collection<? extends GrantedAuthority> authorities) {
        return new OneTimeTokenAuthenticationToken(principal, authorities);
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    @Override
    public Object getCredentials() {
        return this.tokenValue;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }
}

