/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang3.StringUtils;

public class ClientUtils {
    public static File getExtensionBundleVersionContent(Response response, File outputDirectory) {
        File file;
        block9: {
            String contentDispositionHeader = response.getHeaderString("Content-Disposition");
            if (StringUtils.isBlank((CharSequence)contentDispositionHeader)) {
                throw new IllegalStateException("Content-Disposition header was blank or missing");
            }
            int equalsIndex = contentDispositionHeader.lastIndexOf("=");
            String filename = contentDispositionHeader.substring(equalsIndex + 1).trim();
            File bundleFile = new File(outputDirectory, filename);
            InputStream responseInputStream = (InputStream)response.readEntity(InputStream.class);
            try {
                Files.copy(responseInputStream, bundleFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                file = bundleFile;
                if (responseInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (responseInputStream != null) {
                        try {
                            responseInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to write bundle content due to: " + e.getMessage(), e);
                }
            }
            responseInputStream.close();
        }
        return file;
    }
}

