/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.status.util;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import org.apache.nifi.minifi.commons.status.FlowStatusReport;
import org.apache.nifi.minifi.commons.status.common.BulletinStatus;
import org.apache.nifi.minifi.commons.status.common.ValidationError;
import org.apache.nifi.minifi.commons.status.connection.ConnectionHealth;
import org.apache.nifi.minifi.commons.status.connection.ConnectionStats;
import org.apache.nifi.minifi.commons.status.connection.ConnectionStatusBean;
import org.apache.nifi.minifi.commons.status.controllerservice.ControllerServiceHealth;
import org.apache.nifi.minifi.commons.status.controllerservice.ControllerServiceStatus;
import org.apache.nifi.minifi.commons.status.instance.InstanceHealth;
import org.apache.nifi.minifi.commons.status.instance.InstanceStats;
import org.apache.nifi.minifi.commons.status.instance.InstanceStatus;
import org.apache.nifi.minifi.commons.status.processor.ProcessorHealth;
import org.apache.nifi.minifi.commons.status.processor.ProcessorStats;
import org.apache.nifi.minifi.commons.status.processor.ProcessorStatusBean;
import org.apache.nifi.minifi.commons.status.reportingTask.ReportingTaskHealth;
import org.apache.nifi.minifi.commons.status.reportingTask.ReportingTaskStatus;
import org.apache.nifi.minifi.commons.status.rpg.PortStatus;
import org.apache.nifi.minifi.commons.status.rpg.RemoteProcessGroupHealth;
import org.apache.nifi.minifi.commons.status.rpg.RemoteProcessGroupStats;
import org.apache.nifi.minifi.commons.status.rpg.RemoteProcessGroupStatusBean;
import org.apache.nifi.minifi.commons.status.system.ContentRepositoryUsage;
import org.apache.nifi.minifi.commons.status.system.FlowfileRepositoryUsage;
import org.apache.nifi.minifi.commons.status.system.GarbageCollectionStatus;
import org.apache.nifi.minifi.commons.status.system.HeapStatus;
import org.apache.nifi.minifi.commons.status.system.SystemDiagnosticsStatus;
import org.apache.nifi.minifi.commons.status.system.SystemProcessorStats;

public class StatusReportPopulator {
    private StatusReportPopulator() {
    }

    public static void addProcessorStatus(FlowStatusReport flowStatusReport, boolean addHealth, boolean validationErrors, boolean addStats, boolean addBulletins, boolean populateBulletins) {
        ProcessorStatusBean expectedProcessorStatus = new ProcessorStatusBean();
        expectedProcessorStatus.setId("UpdateAttributeProcessorId");
        expectedProcessorStatus.setName("UpdateAttributeProcessorName");
        if (addHealth) {
            ProcessorHealth processorHealth = new ProcessorHealth();
            processorHealth.setHasBulletins(populateBulletins);
            processorHealth.setRunStatus("Stopped");
            if (validationErrors) {
                LinkedList<ValidationError> validationErrorList = new LinkedList<ValidationError>();
                ValidationError validationError1 = new ValidationError();
                validationError1.setInput("input");
                validationError1.setSubject("subject");
                validationError1.setReason("is not valid");
                validationErrorList.add(validationError1);
                ValidationError validationError2 = new ValidationError();
                validationError2.setInput("input2");
                validationError2.setSubject("subject2");
                validationError2.setReason("is not valid too");
                validationErrorList.add(validationError2);
                processorHealth.setValidationErrorList(validationErrorList);
            } else {
                processorHealth.setValidationErrorList(Collections.EMPTY_LIST);
            }
            expectedProcessorStatus.setProcessorHealth(processorHealth);
        }
        if (addStats) {
            ProcessorStats expectedProcessorStats = new ProcessorStats();
            expectedProcessorStats.setActiveThreads(1);
            expectedProcessorStats.setFlowfilesReceived(2);
            expectedProcessorStats.setBytesRead(3L);
            expectedProcessorStats.setBytesWritten(4L);
            expectedProcessorStats.setFlowfilesSent(5);
            expectedProcessorStats.setInvocations(6);
            expectedProcessorStats.setProcessingNanos(7L);
            expectedProcessorStatus.setProcessorStats(expectedProcessorStats);
        }
        if (addBulletins) {
            if (populateBulletins) {
                BulletinStatus bulletinStatus = new BulletinStatus();
                bulletinStatus.setMessage("Bulletin message");
                bulletinStatus.setTimestamp(new Date(1464019245000L));
                expectedProcessorStatus.setBulletinList(Collections.singletonList(bulletinStatus));
            } else {
                expectedProcessorStatus.setBulletinList(Collections.EMPTY_LIST);
            }
        }
        flowStatusReport.setProcessorStatusList(Collections.singletonList(expectedProcessorStatus));
    }

    public static void addConnectionStatus(FlowStatusReport flowStatusReport, boolean addHealth, boolean addStats) {
        ConnectionStatusBean expectedConnectionStatus = new ConnectionStatusBean();
        expectedConnectionStatus.setId("connectionId");
        expectedConnectionStatus.setName("connectionName");
        if (addHealth) {
            ConnectionHealth connectionHealth = new ConnectionHealth();
            connectionHealth.setQueuedCount(10);
            connectionHealth.setQueuedBytes(100L);
            expectedConnectionStatus.setConnectionHealth(connectionHealth);
        }
        if (addStats) {
            ConnectionStats expectedConnectionStats = new ConnectionStats();
            expectedConnectionStats.setInputCount(1);
            expectedConnectionStats.setInputBytes(2L);
            expectedConnectionStats.setOutputCount(3);
            expectedConnectionStats.setOutputBytes(4L);
            expectedConnectionStatus.setConnectionStats(expectedConnectionStats);
        }
        flowStatusReport.setConnectionStatusList(Collections.singletonList(expectedConnectionStatus));
    }

    public static void addExpectedRemoteProcessGroupStatus(FlowStatusReport flowStatusReport, boolean addHealth, boolean addInputPort, boolean addOutputPort, boolean addStats, boolean addBulletins, boolean populateBulletins) {
        RemoteProcessGroupStatusBean expectedRemoteProcessGroupStatus = new RemoteProcessGroupStatusBean();
        expectedRemoteProcessGroupStatus.setName("rpg1");
        if (addHealth) {
            RemoteProcessGroupHealth remoteProcessGroupHealth = new RemoteProcessGroupHealth();
            remoteProcessGroupHealth.setTransmissionStatus("Transmitting");
            remoteProcessGroupHealth.setHasBulletins(populateBulletins);
            remoteProcessGroupHealth.setActivePortCount(1);
            remoteProcessGroupHealth.setInactivePortCount(2);
            expectedRemoteProcessGroupStatus.setRemoteProcessGroupHealth(remoteProcessGroupHealth);
        }
        if (addBulletins) {
            if (populateBulletins) {
                BulletinStatus bulletinStatus = new BulletinStatus();
                bulletinStatus.setMessage("Bulletin message");
                bulletinStatus.setTimestamp(new Date(1464019245000L));
                expectedRemoteProcessGroupStatus.setBulletinList(Collections.singletonList(bulletinStatus));
            } else {
                expectedRemoteProcessGroupStatus.setBulletinList(Collections.EMPTY_LIST);
            }
        }
        if (addInputPort) {
            PortStatus expectedInputPortStatus = new PortStatus();
            expectedInputPortStatus.setName("inputPort");
            expectedInputPortStatus.setTargetExists(true);
            expectedInputPortStatus.setTargetRunning(false);
            expectedRemoteProcessGroupStatus.setInputPortStatusList(Collections.singletonList(expectedInputPortStatus));
        }
        if (addOutputPort) {
            PortStatus expectedOutputPortStatus = new PortStatus();
            expectedOutputPortStatus.setName("outputPort");
            expectedOutputPortStatus.setTargetExists(true);
            expectedOutputPortStatus.setTargetRunning(false);
            expectedRemoteProcessGroupStatus.setOutputPortStatusList(Collections.singletonList(expectedOutputPortStatus));
        }
        if (addStats) {
            RemoteProcessGroupStats remoteProcessGroupStats = new RemoteProcessGroupStats();
            remoteProcessGroupStats.setActiveThreads(3);
            remoteProcessGroupStats.setSentContentSize(4L);
            remoteProcessGroupStats.setSentCount(5);
            expectedRemoteProcessGroupStatus.setRemoteProcessGroupStats(remoteProcessGroupStats);
        }
        flowStatusReport.setRemoteProcessGroupStatusList(Collections.singletonList(expectedRemoteProcessGroupStatus));
    }

    public static void addControllerServiceStatus(FlowStatusReport flowStatusReport, boolean addHealth, boolean addValidationErrors, boolean addBulletins, boolean populateBulletins) {
        ControllerServiceStatus controllerServiceStatus = new ControllerServiceStatus();
        controllerServiceStatus.setName("mockControllerService");
        if (addBulletins) {
            if (populateBulletins) {
                BulletinStatus bulletinStatus = new BulletinStatus();
                bulletinStatus.setMessage("Bulletin message");
                bulletinStatus.setTimestamp(new Date(1464019245000L));
                controllerServiceStatus.setBulletinList(Collections.singletonList(bulletinStatus));
            } else {
                controllerServiceStatus.setBulletinList(Collections.EMPTY_LIST);
            }
        }
        if (addHealth) {
            ControllerServiceHealth controllerServiceHealth = new ControllerServiceHealth();
            controllerServiceHealth.setState("ENABLED");
            controllerServiceHealth.setHasBulletins(populateBulletins);
            controllerServiceStatus.setControllerServiceHealth(controllerServiceHealth);
            if (addValidationErrors) {
                LinkedList<ValidationError> validationErrorList = new LinkedList<ValidationError>();
                ValidationError validationError1 = new ValidationError();
                validationError1.setInput("input");
                validationError1.setSubject("subject");
                validationError1.setReason("is not valid");
                validationErrorList.add(validationError1);
                ValidationError validationError2 = new ValidationError();
                validationError2.setInput("input2");
                validationError2.setSubject("subject2");
                validationError2.setReason("is not valid too");
                validationErrorList.add(validationError2);
                controllerServiceHealth.setValidationErrorList(validationErrorList);
            } else {
                controllerServiceHealth.setValidationErrorList(Collections.EMPTY_LIST);
            }
        }
        flowStatusReport.setControllerServiceStatusList(Collections.singletonList(controllerServiceStatus));
    }

    public static void addInstanceStatus(FlowStatusReport flowStatusReport, boolean addHealth, boolean addStats, boolean addBulletins, boolean populateBulletins) {
        InstanceStatus instanceStatus = new InstanceStatus();
        if (addHealth) {
            InstanceHealth instanceHealth = new InstanceHealth();
            instanceHealth.setQueuedContentSize(1.0);
            instanceHealth.setQueuedCount(2);
            instanceHealth.setActiveThreads(3);
            instanceHealth.setHasBulletins(populateBulletins);
            instanceStatus.setInstanceHealth(instanceHealth);
        }
        if (addBulletins) {
            if (populateBulletins) {
                BulletinStatus bulletinStatus = new BulletinStatus();
                bulletinStatus.setMessage("Bulletin message");
                bulletinStatus.setTimestamp(new Date(1464019245000L));
                instanceStatus.setBulletinList(Collections.singletonList(bulletinStatus));
            } else {
                instanceStatus.setBulletinList(Collections.EMPTY_LIST);
            }
        }
        if (addStats) {
            InstanceStats instanceStats = new InstanceStats();
            instanceStats.setBytesRead(1L);
            instanceStats.setBytesWritten(2L);
            instanceStats.setBytesSent(3L);
            instanceStats.setFlowfilesSent(4);
            instanceStats.setBytesTransferred(5L);
            instanceStats.setFlowfilesTransferred(6);
            instanceStats.setBytesReceived(7L);
            instanceStats.setFlowfilesReceived(8);
            instanceStatus.setInstanceStats(instanceStats);
        }
        flowStatusReport.setInstanceStatus(instanceStatus);
    }

    public static void addSystemDiagnosticStatus(FlowStatusReport flowStatusReport, boolean addHeap, boolean addProcessorStats, boolean addFlowFileRepoUsage, boolean addContentRepoUsage, boolean addGarbageCollectionStatus) {
        SystemDiagnosticsStatus expectedSystemDiagnosticStatus = new SystemDiagnosticsStatus();
        if (addHeap) {
            HeapStatus heapStatus = new HeapStatus();
            heapStatus.setMaxHeap(5L);
            heapStatus.setTotalHeap(3L);
            heapStatus.setUsedHeap(2L);
            heapStatus.setFreeHeap(1L);
            heapStatus.setHeapUtilization(40);
            heapStatus.setMaxNonHeap(9L);
            heapStatus.setTotalNonHeap(8L);
            heapStatus.setUsedNonHeap(6L);
            heapStatus.setFreeNonHeap(2L);
            heapStatus.setNonHeapUtilization(67);
            expectedSystemDiagnosticStatus.setHeapStatus(heapStatus);
        }
        if (addProcessorStats) {
            SystemProcessorStats systemProcessorStats = new SystemProcessorStats();
            systemProcessorStats.setLoadAverage(80.9);
            systemProcessorStats.setAvailableProcessors(5);
            expectedSystemDiagnosticStatus.setProcessorStatus(systemProcessorStats);
        }
        if (addFlowFileRepoUsage) {
            FlowfileRepositoryUsage flowfileRepositoryUsage = new FlowfileRepositoryUsage();
            flowfileRepositoryUsage.setFreeSpace(30L);
            flowfileRepositoryUsage.setTotalSpace(100L);
            flowfileRepositoryUsage.setUsedSpace(70L);
            flowfileRepositoryUsage.setDiskUtilization(70);
            expectedSystemDiagnosticStatus.setFlowfileRepositoryUsage(flowfileRepositoryUsage);
        }
        if (addContentRepoUsage) {
            LinkedList<ContentRepositoryUsage> contentRepositoryUsageList = new LinkedList<ContentRepositoryUsage>();
            ContentRepositoryUsage contentRepositoryUsage = new ContentRepositoryUsage();
            contentRepositoryUsage.setFreeSpace(30L);
            contentRepositoryUsage.setTotalSpace(100L);
            contentRepositoryUsage.setName("Content repo1");
            contentRepositoryUsage.setUsedSpace(70L);
            contentRepositoryUsage.setDiskUtilization(70);
            contentRepositoryUsageList.add(contentRepositoryUsage);
            expectedSystemDiagnosticStatus.setContentRepositoryUsageList(contentRepositoryUsageList);
        }
        if (addGarbageCollectionStatus) {
            LinkedList<GarbageCollectionStatus> garbageCollectionStatusList = new LinkedList<GarbageCollectionStatus>();
            GarbageCollectionStatus garbageCollectionStatus1 = new GarbageCollectionStatus();
            garbageCollectionStatus1.setCollectionCount(1L);
            garbageCollectionStatus1.setCollectionTime(10L);
            garbageCollectionStatus1.setName("garbage 1");
            garbageCollectionStatusList.add(garbageCollectionStatus1);
            expectedSystemDiagnosticStatus.setGarbageCollectionStatusList(garbageCollectionStatusList);
        }
        flowStatusReport.setSystemDiagnosticsStatus(expectedSystemDiagnosticStatus);
    }

    public static void addReportingTaskStatus(FlowStatusReport flowStatusReport, boolean addHealth, boolean addValidationErrors, boolean addBulletins, boolean populateBulletins) {
        ReportingTaskStatus reportingTaskStatus = new ReportingTaskStatus();
        reportingTaskStatus.setName("ReportProvenance");
        if (addHealth) {
            ReportingTaskHealth reportingTaskHealth = new ReportingTaskHealth();
            reportingTaskHealth.setActiveThreads(1);
            reportingTaskHealth.setScheduledState("RUNNING");
            reportingTaskHealth.setHasBulletins(populateBulletins);
            if (addValidationErrors) {
                LinkedList<ValidationError> validationErrorList = new LinkedList<ValidationError>();
                ValidationError validationError1 = new ValidationError();
                validationError1.setInput("input");
                validationError1.setSubject("subject");
                validationError1.setReason("is not valid");
                validationErrorList.add(validationError1);
                ValidationError validationError2 = new ValidationError();
                validationError2.setInput("input2");
                validationError2.setSubject("subject2");
                validationError2.setReason("is not valid too");
                validationErrorList.add(validationError2);
                reportingTaskHealth.setValidationErrorList(validationErrorList);
            } else {
                reportingTaskHealth.setValidationErrorList(Collections.EMPTY_LIST);
            }
            reportingTaskStatus.setReportingTaskHealth(reportingTaskHealth);
        }
        if (addBulletins) {
            if (populateBulletins) {
                BulletinStatus bulletinStatus = new BulletinStatus();
                bulletinStatus.setMessage("Bulletin message");
                bulletinStatus.setTimestamp(new Date(1464019245000L));
                reportingTaskStatus.setBulletinList(Collections.singletonList(bulletinStatus));
            } else {
                reportingTaskStatus.setBulletinList(Collections.EMPTY_LIST);
            }
        }
        flowStatusReport.setReportingTaskStatusList(Collections.singletonList(reportingTaskStatus));
    }
}

